/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/08 23:54:54
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;

/**
 * @author takeshi
 */
public class MergeDatabases extends RdbCommand {

    /**
     *  
     */
    public MergeDatabases() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorMock#visit(org.asyrinx.joey.gen.model.rdb.Databases)
     */
    public void visit(Databases databases) {
        final Map dbMap = new HashMap();
        //final List dbList = databases.getDatabases().toList();
        for (final Iterator i = databases.getDatabases().iterator(); i.hasNext();) {
            final Database db = (Database) i.next();
            final Database committed = (Database) dbMap.get(db.getName());
            if (committed == null) {
                dbMap.put(db.getName(), db);
            } else {
                db.moveTables(committed);
                db.moveEnumerations(committed);
                i.remove();
            }
        }
    }
}