/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/26 15:58:51
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class PrepareColumnFk extends RdbCommand {

    /**
     *  
     */
    public PrepareColumnFk() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorMock#visit(org.asyrinx.joey.gen.model.rdb.Column)
     */
    public void visit(Column column) {
        if (StringUtils.isEmpty(column.getFk()))
            return;
        final Table localTable = column.getParent();
        final Database db = localTable.getParent();
        final Column fkCol = db.getColumn(column.getFk());
        if (fkCol == null) {
            addError(column, "cannot find:" + column.getFk());
            return;
        }
        final ForeignKey foreignKey = new ForeignKey(localTable, fkCol.getParent().getName());
        foreignKey.setType(ForeignKeyType.NORMAL);
        new ForeignKeyEntry(foreignKey, column.getName(), fkCol.getName());
    }

}