/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/27 2:31:31
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class BasicNaming implements NamingStrategy {

    /**
     *  
     */
    public BasicNaming() {
        super();
    }

    private char separator = '_';

    protected String doUnderscoreBasedNaming(String schemaName) {
        final StringBuffer result = new StringBuffer();
        final List parts = StringUtils.tokenize(schemaName, String.valueOf(getSeparator()));
        for (Iterator i = parts.iterator(); i.hasNext();) {
            String namePart = i.next().toString().toLowerCase();
            result.append(StringUtils.capitalize(namePart));
        }
        return result.toString();
    }

    protected String toName(Element element) {
        final Object optionName = element.getOptions().get(JavaOptions.JAVA_NAME);
        return (optionName != null) ? optionName.toString() : doUnderscoreBasedNaming(element.getName());
    }

    private final String[] EnumPropertyDeleteTargets = new String[] { "Id", "Cd", "Code", "No" };

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.NamingStrategy#toEnumPropertyName(java.lang.String)
     */
    public String toEnumPropertyName(String name) {
        for (int i = 0; i < EnumPropertyDeleteTargets.length; i++) {
            if (name.endsWith(EnumPropertyDeleteTargets[i])) {
                return name.substring(0, name.length() - EnumPropertyDeleteTargets[i].length());
            }
        }
        return name + "Enum";
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.NamingStrategy#toClassName(org.asyrinx.joey.gen.model.rdb.Table)
     */
    public String toAppDomainName(Databases databases) {
        return toName(databases);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.NamingStrategy#toEnumerationName(org.asyrinx.joey.gen.model.rdb.RdbEnumeration)
     */
    public String toEnumerationName(RdbEnumeration enumeration) {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.NamingStrategy#toClassName(org.asyrinx.joey.gen.model.rdb.Table)
     */
    public String toClassName(Table table) {
        return toName(table);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.NamingStrategy#toPropertyName(org.asyrinx.joey.gen.model.rdb.Column)
     */
    public String toPropertyName(Column column) {
        return StringUtils.uncapitalize(toName(column));
    }

    /**
     * @return Returns the separator.
     */
    public char getSeparator() {
        return separator;
    }

    /**
     * @param separator
     *            The separator to set.
     */
    public void setSeparator(char separator) {
        this.separator = separator;
    }
}