/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 18:06:50
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * @author akima
 */
public abstract class ElementSet extends Element {
    /**
     * @param name
     */
    public ElementSet(String name) {
        this(null, name, null);
    }

    /**
     * @param parent
     */
    public ElementSet(Element parent) {
        this(parent, null, null);
    }

    /**
     * @param parent
     * @param name
     */
    public ElementSet(Element parent, String name) {
        this(parent, name, null);
    }

    /**
     * @param parent
     * @param name
     * @param label
     * @param isEntity
     */
    public ElementSet(Element parent, String name, String label) {
        super(parent, name, label);
    }

    protected final List elementList = new ArrayList();

    /**
     * @return Returns the entity.
     */
    abstract public boolean isEntity();

    public void add(Element element) {
        if (element == null)
            throw new NullPointerException("element must not be null");
        if (!elementList.contains(element))
            elementList.add(element);
        if (element.getParentElement() != this)
            element.setParentElement(isEntity() ? this : this.getParentElement());
    }

    /**
     *  
     */
    public final void clear() {
        elementList.clear();
    }

    /**
     * @param key
     * @return
     */
    public final boolean contains(String name) {
        if (StringUtils.isEmpty(name))
            return false;
        for (int i = 0; i < elementList.size(); i++) {
            final Element element = (Element) elementList.get(i);
            if (name.equals(element.getName()))
                return true;
        }
        return false;
    }

    /**
     * @param value
     * @return
     */
    protected boolean contains(Element element) {
        return elementList.contains(element);
    }

    /**
     * @param key
     * @return
     */
    protected Element getElement(int index) {
        return (index < 0) ? null : (Element) elementList.get(index);
    }

    /**
     * @param key
     * @return
     */
    protected Element getElement(String name) {
        return getElement(indexOf(name));
    }

    /**
     * @param key
     * @return
     */
    public final int indexOf(String name) {
        if (StringUtils.isEmpty(name))
            return -1;
        for (int i = 0; i < elementList.size(); i++) {
            final Element element = (Element) elementList.get(i);
            if (name.equals(element.getName()))
                return i;
        }
        return -1;
    }

    /**
     * @param key
     * @return
     */
    public final int indexOf(Element element) {
        return elementList.indexOf(element);
    }

    /**
     * @return
     */
    public final boolean isEmpty() {
        return elementList.isEmpty();
    }

    /**
     * @return
     */
    public final Iterator iterator() {
        return elementList.iterator();
    }

    /**
     * @param key
     * @return
     */
    protected Element removeElement(String name) {
        final int index = indexOf(name);
        return (index < 0) ? null : (Element) elementList.remove(index);
    }

    /**
     * @return
     */
    public final int size() {
        return elementList.size();
    }

    public List toList() {
        return new ArrayList(this.elementList);
    }
}