/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 14:54:07
 */
package org.asyrinx.joey.gen.model.rdb.visitor;

import java.util.Iterator;

import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.PrimaryKey;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.RdbVisitor;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.Unique;

/**
 * @author akima
 */
public class RdbTopDownVisitor extends RdbVisitorWrapper {

    /**
     * @param rdbVisitor
     */
    public RdbTopDownVisitor(RdbVisitor rdbVisitor) {
        super(rdbVisitor);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Column)
     */
    public void visit(Column column) {
        super.visit(column);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Database)
     */
    public void visit(Database database) {
        super.visit(database);
        for (Iterator iter = database.getEnumerations().iterator(); iter.hasNext();) {
            final RdbEnumeration element = (RdbEnumeration) iter.next();
            visit(element);
        }
        for (Iterator iter = database.getTables().iterator(); iter.hasNext();) {
            final Table element = (Table) iter.next();
            visit(element);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Databases)
     */
    public void visit(Databases databases) {
        super.visit(databases);
        for (Iterator iter = databases.getDatabases().iterator(); iter.hasNext();) {
            final Database element = (Database) iter.next();
            visit(element);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.JavaEnumeration)
     */
    public void visit(RdbEnumeration enumeration) {
        super.visit(enumeration);
        for (Iterator iter = enumeration.iterator(); iter.hasNext();) {
            final EnumerationEntry element = (EnumerationEntry) iter.next();
            visit(element);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.EnumerationEntry)
     */
    public void visit(EnumerationEntry enumerationEntry) {
        super.visit(enumerationEntry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.ForeignKey)
     */
    public void visit(ForeignKey foreignKey) {
        super.visit(foreignKey);
        for (Iterator iter = foreignKey.iterator(); iter.hasNext();) {
            final ForeignKeyEntry element = (ForeignKeyEntry) iter.next();
            visit(element);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry)
     */
    public void visit(ForeignKeyEntry foreignKeyEntry) {
        super.visit(foreignKeyEntry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Index)
     */
    public void visit(Index index) {
        super.visit(index);
        for (Iterator iter = index.iterator(); iter.hasNext();) {
            final IndexEntry element = (IndexEntry) iter.next();
            visit(element);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.IndexEntry)
     */
    public void visit(IndexEntry indexEntry) {
        super.visit(indexEntry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorWrapper#visit(org.asyrinx.joey.gen.model.rdb.PrimaryKey)
     */
    public void visit(PrimaryKey primaryKey) {
        super.visit(primaryKey);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Table)
     */
    public void visit(Table table) {
        super.visit(table);
        for (Iterator iter = table.getColumns().iterator(); iter.hasNext();) {
            final Column element = (Column) iter.next();
            visit(element);
        }
        visit(table.getPrimaryKey());
        for (Iterator iter = table.getIndexes().iterator(); iter.hasNext();) {
            final Index element = (Index) iter.next();
            visit(element);
        }
        for (Iterator iter = table.getUniques().iterator(); iter.hasNext();) {
            final Index element = (Index) iter.next();
            visit(element);
        }
        for (Iterator iter = table.getForeignKeys().iterator(); iter.hasNext();) {
            final ForeignKey element = (ForeignKey) iter.next();
            visit(element);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorWrapper#visit(org.asyrinx.joey.gen.model.rdb.Unique)
     */
    public void visit(Unique unique) {
        super.visit(unique);
        for (Iterator iter = unique.iterator(); iter.hasNext();) {
            final IndexEntry element = (IndexEntry) iter.next();
            visit(element);
        }
    }
}