/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public interface MapTreeKey
extends Serializable {
    public static final MapTreeKey NULL = new MapTreeKey(){
        final Object[] result = new Object[0];

        public Object[] toArray() {
            return this.result;
        }

        public int getDepth() {
            return 0;
        }
    };

    public Object[] toArray();

    public int getDepth();

    public static class Default
    implements MapTreeKey {
        private final Object[] key;

        public Default(Object[] key) {
            this.key = key;
        }

        public Object[] toArray() {
            return this.key;
        }

        public int getDepth() {
            return this.key.length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MapTreeKey) {
                MapTreeKey mapTreeKey = (MapTreeKey)obj;
                return new EqualsBuilder().append(this.key, mapTreeKey.toArray()).isEquals();
            }
            if (obj instanceof Object[]) {
                return new EqualsBuilder().append(this.key, (Object[])obj).isEquals();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.key).hashCode();
        }
    }

    public static class Wrapper
    implements MapTreeKey {
        protected final MapTreeKey wrapped;

        public Wrapper(MapTreeKey wrapped) {
            this.wrapped = wrapped;
        }

        public int getDepth() {
            return this.wrapped.getDepth();
        }

        public Object[] toArray() {
            return this.wrapped.toArray();
        }
    }

    public static final class Buffered
    extends Wrapper {
        private Object[] result = null;

        public Buffered(MapTreeKey wrapped) {
            super(wrapped);
        }

        public Object[] toArray() {
            if (this.result == null) {
                this.result = super.toArray();
            }
            return this.result;
        }

        public int getDepth() {
            return this.toArray().length;
        }
    }
}

