/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.asyrinx.brownie.jdbc.wrapper.ResultSetWrapper;

class ResultSetMaxCountFilter
extends ResultSetWrapper {
    private final int maxCount;
    private int count = 0;

    public ResultSetMaxCountFilter(ResultSet impl, int maxCount) {
        super(impl);
        this.maxCount = maxCount;
    }

    public boolean next() throws SQLException {
        boolean result = super.next();
        if (result) {
            ++this.count;
        }
        if (this.maxCount < 1) {
            return result;
        }
        if (!result) {
            return false;
        }
        return this.count <= this.maxCount;
    }

    public boolean previous() throws SQLException {
        boolean result = super.previous();
        if (result) {
            --this.count;
        }
        return result;
    }
}

