/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheFactory;
import net.sf.hibernate.cfg.Binder;
import net.sf.hibernate.cfg.DefaultNamingStrategy;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.cfg.Mappings;
import net.sf.hibernate.cfg.NamingStrategy;
import net.sf.hibernate.cfg.Settings;
import net.sf.hibernate.cfg.SettingsFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.PersistentIdentifierGenerator;
import net.sf.hibernate.impl.SessionFactoryImpl;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.ForeignKey;
import net.sf.hibernate.mapping.IdentifierCollection;
import net.sf.hibernate.mapping.Index;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.RootClass;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.tool.hbm2ddl.DatabaseMetadata;
import net.sf.hibernate.tool.hbm2ddl.TableMetadata;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.XMLHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.xml.sax.InputSource;

public class Configuration {
    private Map classes = new HashMap();
    private Map imports = new HashMap();
    private Map collections = new HashMap();
    private Map tables = new HashMap();
    private Map namedQueries = new HashMap();
    private Map namedSqlQueries = new HashMap();
    private List secondPasses = new ArrayList();
    private List propertyReferences = new ArrayList();
    private Interceptor interceptor = EMPTY_INTERCEPTOR;
    private Properties properties = Environment.getProperties();
    private Map caches = new HashMap();
    private NamingStrategy namingStrategy = DefaultNamingStrategy.INSTANCE;
    private static Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cfg$Configuration == null ? (class$net$sf$hibernate$cfg$Configuration = Configuration.class$("net.sf.hibernate.cfg.Configuration")) : class$net$sf$hibernate$cfg$Configuration));
    private Mapping mapping = new Mapping(){

        public Type getIdentifierType(Class persistentClass) throws MappingException {
            return ((PersistentClass)Configuration.this.classes.get(persistentClass)).getIdentifier().getType();
        }

        public String getIdentifierPropertyName(Class persistentClass) throws MappingException {
            return ((PersistentClass)Configuration.this.classes.get(persistentClass)).getIdentifierProperty().getName();
        }

        public Type getPropertyType(Class persistentClass, String propertyName) throws MappingException {
            return ((PersistentClass)Configuration.this.classes.get(persistentClass)).getProperty(propertyName).getType();
        }
    };
    private static final Interceptor EMPTY_INTERCEPTOR = new EmptyInterceptor();
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Configuration;
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Environment;

    protected void reset() {
        this.classes = new HashMap();
        this.collections = new HashMap();
        this.tables = new HashMap();
        this.namedQueries = new HashMap();
        this.namedSqlQueries = new HashMap();
        this.secondPasses = new ArrayList();
        this.interceptor = EMPTY_INTERCEPTOR;
        this.properties = Environment.getProperties();
    }

    public Configuration() {
        this.reset();
    }

    public Iterator getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    private Iterator getTableMappings() {
        return this.tables.values().iterator();
    }

    public PersistentClass getClassMapping(Class persistentClass) {
        return (PersistentClass)this.classes.get(persistentClass);
    }

    public Collection getCollectionMapping(String role) {
        return (Collection)this.collections.get(role);
    }

    public Configuration addFile(String xmlFile) throws MappingException {
        log.info((Object)("Mapping file: " + xmlFile));
        try {
            ArrayList errors = new ArrayList();
            Document doc = XMLHelper.createSAXReader(xmlFile, errors).read(new File(xmlFile));
            if (errors.size() != 0) {
                throw new MappingException("invalid mapping", (Throwable)errors.get(0));
            }
            this.add(doc);
            return this;
        }
        catch (Exception e) {
            log.error((Object)("Could not configure datastore from file: " + xmlFile), (Throwable)e);
            throw new MappingException(e);
        }
    }

    public Configuration addFile(File xmlFile) throws MappingException {
        log.info((Object)("Mapping file: " + xmlFile.getPath()));
        try {
            this.addInputStream(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure datastore from file: " + xmlFile.getPath()), (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addXML(String xml) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + xml));
        }
        try {
            ArrayList errors = new ArrayList();
            Document doc = XMLHelper.createSAXReader("XML String", errors).read((Reader)new StringReader(xml));
            if (errors.size() != 0) {
                throw new MappingException("invalid mapping", (Throwable)errors.get(0));
            }
            this.add(doc);
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from XML", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addURL(URL url) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping URL:\n" + url));
        }
        try {
            this.addInputStream(url.openStream());
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from URL", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addDocument(org.w3c.dom.Document doc) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + doc));
        }
        try {
            this.add(XMLHelper.createDOMReader().read(doc));
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from XML document", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    protected void add(Document doc) throws Exception {
        try {
            Binder.bindRoot(doc, this.createMappings());
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping document", (Throwable)me);
            throw me;
        }
    }

    public Mappings createMappings() {
        return new Mappings(this.classes, this.collections, this.tables, this.namedQueries, this.namedSqlQueries, this.imports, this.caches, this.secondPasses, this.propertyReferences, this.namingStrategy);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        Configuration configuration;
        try {
            try {
                ArrayList errors = new ArrayList();
                Document doc = XMLHelper.createSAXReader("XML InputStream", errors).read(new InputSource(xmlInputStream));
                if (errors.size() != 0) {
                    throw new MappingException("invalid mapping", (Throwable)errors.get(0));
                }
                this.add(doc);
                configuration = this;
                Object var6_7 = null;
            }
            catch (MappingException me) {
                throw me;
            }
            catch (Exception e) {
                log.error((Object)"Could not configure datastore from input stream", (Throwable)e);
                throw new MappingException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                xmlInputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                log.error((Object)"could not close input stream", (Throwable)ioe);
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            log.error((Object)"could not close input stream", (Throwable)ioe);
            return configuration;
        }
        xmlInputStream.close();
        return configuration;
    }

    public Configuration addResource(String path, ClassLoader classLoader) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = classLoader.getResourceAsStream(path);
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, me);
        }
    }

    public Configuration addResource(String path) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (rsrc == null) {
            rsrc = (class$net$sf$hibernate$cfg$Environment == null ? (class$net$sf$hibernate$cfg$Environment = Configuration.class$("net.sf.hibernate.cfg.Environment")) : class$net$sf$hibernate$cfg$Environment).getClassLoader().getResourceAsStream(path);
        }
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, me);
        }
    }

    public Configuration addClass(Class persistentClass) throws MappingException {
        String fileName = persistentClass.getName().replace('.', '/') + ".hbm.xml";
        log.info((Object)("Mapping resource: " + fileName));
        InputStream rsrc = persistentClass.getClassLoader().getResourceAsStream(fileName);
        if (rsrc == null) {
            throw new MappingException("Resource: " + fileName + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + fileName, me);
        }
    }

    public Configuration addJar(String resource) throws MappingException {
        return this.addJar(new File(Thread.currentThread().getContextClassLoader().getResource(resource).getFile()));
    }

    public Configuration addJar(File jar) throws MappingException {
        JarFile jarFile;
        log.info((Object)("Searching for mapping documents in jar: " + jar.getName()));
        try {
            jarFile = new JarFile(jar);
        }
        catch (IOException ioe) {
            log.error((Object)("Could not configure datastore from jar: " + jar.getName()), (Throwable)ioe);
            throw new MappingException("Could not configure datastore from jar: " + jar.getName(), ioe);
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry ze = enumeration.nextElement();
            if (!ze.getName().endsWith(".hbm.xml")) continue;
            log.info((Object)("Found mapping documents in jar: " + ze.getName()));
            try {
                this.addInputStream(jarFile.getInputStream(ze));
            }
            catch (MappingException me) {
                throw me;
            }
            catch (Exception e) {
                log.error((Object)"Could not configure datastore from jar", (Throwable)e);
                throw new MappingException(e);
            }
        }
        return this;
    }

    public Configuration addDirectory(File dir) throws MappingException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirectory(files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(".hbm.xml")) continue;
            this.addFile(files[i]);
        }
        return this;
    }

    private Iterator iterateGenerators(Dialect dialect) throws MappingException {
        HashMap<Object, IdentifierGenerator> generators = new HashMap<Object, IdentifierGenerator>();
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            IdentifierGenerator ig = ((PersistentClass)iter.next()).getIdentifier().createIdentifierGenerator(dialect);
            if (!(ig instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            IdentifierGenerator ig;
            Collection collection = (Collection)iter.next();
            if (!(collection instanceof IdentifierCollection) || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(dialect)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        Table table;
        Iterator iter;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        if (dialect.dropConstraints()) {
            iter = this.getTableMappings();
            while (iter.hasNext()) {
                table = (Table)iter.next();
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    script.add(fk.sqlDropString(dialect));
                }
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            script.add(table.sqlDropString(dialect));
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String dropString = ((PersistentIdentifierGenerator)iter.next()).sqlDropString(dialect);
            if (dropString == null) continue;
            script.add(dropString);
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            script.add(table.sqlCreateString(dialect, this.mapping));
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            Iterator subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, this.mapping));
            }
            if (!dialect.hasAlterTable()) continue;
            subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                script.add(fk.sqlCreateString(dialect, this.mapping));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlCreateStrings(dialect);
            for (int i = 0; i < lines.length; ++i) {
                script.add(lines[i]);
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        TableMetadata tableInfo;
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            tableInfo = databaseMetadata.getTableMetadata(table.getName());
            if (tableInfo == null) {
                script.add(table.sqlCreateString(dialect, this.mapping));
                continue;
            }
            Iterator subiter = table.sqlAlterStrings(dialect, this.mapping, tableInfo);
            while (subiter.hasNext()) {
                script.add((String)subiter.next());
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            tableInfo = databaseMetadata.getTableMetadata(table.getName());
            if (!dialect.hasAlterTable()) continue;
            Iterator subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                if (tableInfo != null && tableInfo.getForeignKeyMetadata(fk.getName()) != null) continue;
                script.add(fk.sqlCreateString(dialect, this.mapping));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            String[] lines = generator.sqlCreateStrings(dialect);
            for (int i = 0; i < lines.length; ++i) {
                script.add(lines[i]);
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    private void validate() throws MappingException {
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            ((PersistentClass)iter.next()).validate(this.mapping);
        }
        iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            ((Collection)iter.next()).validate(this.mapping);
        }
    }

    private void secondPassCompile() throws MappingException {
        log.info((Object)"processing one-to-many association mappings");
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            Binder.SecondPass sp = (Binder.SecondPass)iter.next();
            sp.doSecondPass(this.classes);
            iter.remove();
        }
        log.info((Object)"processing one-to-one association property references");
        iter = this.propertyReferences.iterator();
        while (iter.hasNext()) {
            Mappings.UniquePropertyReference upr = (Mappings.UniquePropertyReference)iter.next();
            PersistentClass clazz = this.getClassMapping(upr.referencedClass);
            if (clazz == null) {
                throw new MappingException("property-ref to unmapped class: " + upr.referencedClass.getName());
            }
            boolean found = false;
            Iterator propIter = clazz.getPropertyIterator();
            while (propIter.hasNext()) {
                Property prop = (Property)propIter.next();
                if (!upr.propertyName.equals(prop.getName())) continue;
                ((SimpleValue)prop.getValue()).setUnique(true);
                found = true;
                break;
            }
            if (found) continue;
            throw new MappingException("property-ref not found: " + upr.propertyName + " in class: " + upr.referencedClass.getName());
        }
        log.info((Object)"processing foreign key constraints");
        iter = this.getTableMappings();
        HashSet done = new HashSet();
        while (iter.hasNext()) {
            this.secondPassCompileForeignKeys((Table)iter.next(), done);
        }
    }

    private void secondPassCompileForeignKeys(Table table, Set done) throws MappingException {
        Iterator iter = table.getForeignKeyIterator();
        while (iter.hasNext()) {
            PersistentClass referencedClass;
            ForeignKey fk = (ForeignKey)iter.next();
            if (done.contains(fk)) continue;
            done.add(fk);
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolving reference to class: " + fk.getReferencedClass().getName()));
            }
            if ((referencedClass = (PersistentClass)this.classes.get(fk.getReferencedClass())) == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " refers to an unmapped class: " + fk.getReferencedClass().getName());
            }
            if (referencedClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(referencedClass.getSuperclass().getTable(), done);
            }
            fk.setReferencedTable(referencedClass.getTable());
        }
    }

    public Map getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        this.secondPassCompile();
        this.validate();
        Environment.verifyProperties(this.properties);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        Settings settings = this.buildSettings();
        this.configureCaches(settings);
        return new SessionFactoryImpl(this, settings);
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties extraProperties) {
        this.properties.putAll((Map<?, ?>)extraProperties);
        return this;
    }

    public Configuration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    private void addProperties(Element parent) {
        Iterator iter = parent.elementIterator("property");
        while (iter.hasNext()) {
            Element node = (Element)iter.next();
            String name = node.attributeValue("name");
            String value = node.getText().trim();
            log.debug((Object)(name + "=" + value));
            this.properties.setProperty(name, value);
            if (name.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + name, value);
        }
        Environment.verifyProperties(this.properties);
    }

    protected InputStream getConfigurationInputStream(String resource) throws HibernateException {
        log.info((Object)("Configuration resource: " + resource));
        InputStream stream = (class$net$sf$hibernate$cfg$Environment == null ? (class$net$sf$hibernate$cfg$Environment = Configuration.class$("net.sf.hibernate.cfg.Environment")) : class$net$sf$hibernate$cfg$Environment).getResourceAsStream(resource);
        if (stream == null) {
            log.warn((Object)(resource + " not found"));
            throw new HibernateException(resource + " not found");
        }
        return stream;
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws HibernateException {
        log.info((Object)("configuring from resource: " + resource));
        InputStream stream = this.getConfigurationInputStream(resource);
        return this.doConfigure(stream, resource);
    }

    public Configuration configure(URL url) throws HibernateException {
        log.info((Object)("configuring from url: " + url.toString()));
        try {
            return this.doConfigure(url.openStream(), url.toString());
        }
        catch (IOException ioe) {
            throw new HibernateException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws HibernateException {
        log.info((Object)("configuring from file: " + configFile.getName()));
        try {
            return this.doConfigure(new FileInputStream(configFile), configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new HibernateException("could not find file: " + configFile, fnfe);
        }
    }

    /*
     * Loose catch block
     */
    protected Configuration doConfigure(InputStream stream, String resourceName) throws HibernateException {
        Document doc;
        block8: {
            ArrayList errors = new ArrayList();
            doc = XMLHelper.createSAXReader(resourceName, errors).read(new InputSource(stream));
            if (errors.size() != 0) {
                throw new MappingException("invalid configuration", (Throwable)errors.get(0));
            }
            Object var6_6 = null;
            try {
                stream.close();
            }
            catch (IOException ioe) {
                log.error((Object)("could not close stream on: " + resourceName), (Throwable)ioe);
            }
            break block8;
            {
                catch (Exception e) {
                    log.error((Object)("problem parsing configuration" + resourceName), (Throwable)e);
                    throw new HibernateException("problem parsing configuration" + resourceName, e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("could not close stream on: " + resourceName), (Throwable)ioe);
                }
                throw throwable;
            }
        }
        return this.doConfigure(doc);
    }

    public Configuration configure(org.w3c.dom.Document document) throws HibernateException {
        Document doc;
        log.info((Object)"configuring from XML document");
        try {
            doc = XMLHelper.createDOMReader().read(document);
        }
        catch (Exception e) {
            log.error((Object)"problem parsing document", (Throwable)e);
            throw new HibernateException("problem parsing document", e);
        }
        return this.doConfigure(doc);
    }

    protected Configuration doConfigure(Document doc) throws HibernateException {
        Element sfNode = doc.getRootElement().element("session-factory");
        String name = sfNode.attributeValue("name");
        if (name != null) {
            this.properties.setProperty("hibernate.session_factory_name", name);
        }
        this.addProperties(sfNode);
        Iterator elements = sfNode.elementIterator();
        while (elements.hasNext()) {
            CacheConcurrencyStrategy cache;
            String region;
            Attribute regionNode;
            Element mapElement = (Element)elements.next();
            String elemname = mapElement.getName();
            if ("mapping".equals(elemname)) {
                Attribute rsrc = mapElement.attribute("resource");
                Attribute file = mapElement.attribute("file");
                Attribute jar = mapElement.attribute("jar");
                if (rsrc != null) {
                    log.debug((Object)(name + "<-" + rsrc));
                    this.addResource(rsrc.getValue());
                    continue;
                }
                if (jar != null) {
                    log.debug((Object)(name + "<-" + jar));
                    this.addJar(jar.getValue());
                    continue;
                }
                if (file == null) {
                    throw new MappingException("<mapping> element in configuration specifies no attributes");
                }
                log.debug((Object)(name + "<-" + file));
                this.addFile(file.getValue());
                continue;
            }
            if ("jcs-class-cache".equals(elemname) || "class-cache".equals(elemname)) {
                Class clazz;
                String className = mapElement.attributeValue("class");
                try {
                    clazz = ReflectHelper.classForName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MappingException("Could not find class: " + className, cnfe);
                }
                regionNode = mapElement.attribute("region");
                region = regionNode == null ? className : regionNode.getValue();
                cache = CacheFactory.createCache(mapElement, region, this.getRootClassMapping(clazz).isMutable());
                this.setCacheConcurrencyStrategy(clazz, cache, region);
                continue;
            }
            if (!"jcs-collection-cache".equals(elemname) && !"collection-cache".equals(elemname)) continue;
            String role = mapElement.attributeValue("collection");
            Collection collection = this.getCollectionMapping(role);
            regionNode = mapElement.attribute("region");
            region = regionNode == null ? role : regionNode.getValue();
            cache = CacheFactory.createCache(mapElement, region, collection.getOwner().isMutable());
            this.setCacheConcurrencyStrategy(role, cache, region);
        }
        log.info((Object)("Configured SessionFactory: " + name));
        log.debug((Object)("properties: " + this.properties));
        return this;
    }

    RootClass getRootClassMapping(Class clazz) throws MappingException {
        try {
            return (RootClass)this.getClassMapping(clazz);
        }
        catch (ClassCastException cce) {
            throw new MappingException("You may only specify a cache for root <class> mappings");
        }
    }

    public Configuration setCacheConcurrencyStrategy(Class clazz, CacheConcurrencyStrategy concurrencyStrategy) throws MappingException {
        this.setCacheConcurrencyStrategy(clazz, concurrencyStrategy, clazz.getName());
        return this;
    }

    void setCacheConcurrencyStrategy(Class clazz, CacheConcurrencyStrategy concurrencyStrategy, String region) throws MappingException {
        RootClass rootClass = this.getRootClassMapping(clazz);
        rootClass.setCache(concurrencyStrategy);
        this.caches.put(rootClass.getMappedClass().getName(), concurrencyStrategy);
    }

    public Configuration setCacheConcurrencyStrategy(String collectionRole, CacheConcurrencyStrategy concurrencyStrategy) throws MappingException {
        this.setCacheConcurrencyStrategy(collectionRole, concurrencyStrategy, collectionRole);
        return this;
    }

    void setCacheConcurrencyStrategy(String collectionRole, CacheConcurrencyStrategy concurrencyStrategy, String region) throws MappingException {
        Collection collection = this.getCollectionMapping(collectionRole);
        collection.setCache(concurrencyStrategy);
        CacheConcurrencyStrategy old = this.caches.put(collection.getRole(), concurrencyStrategy);
        if (old != null) {
            throw new MappingException("duplicate cache region");
        }
    }

    protected void configureCaches(Settings settings) throws HibernateException {
        log.info((Object)"instantiating and configuring caches");
        String prefix = this.properties.getProperty("hibernate.cache.region_prefix");
        Iterator iter = this.caches.entrySet().iterator();
        while (iter.hasNext()) {
            Cache cache;
            Map.Entry me = iter.next();
            String name = (String)me.getKey();
            if (prefix != null) {
                name = prefix + "." + name;
            }
            CacheConcurrencyStrategy strat = (CacheConcurrencyStrategy)me.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("instantiating cache " + name));
            }
            try {
                cache = settings.getCacheProvider().buildCache(name, this.properties);
            }
            catch (CacheException e) {
                throw new HibernateException("Could not instantiate Cache", e);
            }
            strat.setCache(cache);
            strat.setMinimalPuts(settings.isMinimalPutsEnabled());
        }
        this.caches.clear();
    }

    public Map getImports() {
        return this.imports;
    }

    protected Settings buildSettings() throws HibernateException {
        return SettingsFactory.buildSettings(this.properties);
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class EmptyInterceptor
    implements Interceptor,
    Serializable {
        EmptyInterceptor() {
        }

        public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        }

        public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            return false;
        }

        public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            return false;
        }

        public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            return false;
        }

        public void postFlush(Iterator entities) {
        }

        public void preFlush(Iterator entities) {
        }

        public Boolean isUnsaved(Object entity) {
            return null;
        }

        public Object instantiate(Class clazz, Serializable id) {
            return null;
        }

        public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            return null;
        }
    }
}

