/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.hibernate;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.type.NullableType;
import org.asyrinx.joey.gen.jdbc.JdbcUtils;

public class HibernateUtils {
    public static NullableType getHibernateType(String sqlTypeName, int columnSize, int decimalDigits) {
        int sqlType = JdbcUtils.toJdbcType(sqlTypeName);
        return sqlType == 99999 ? null : HibernateUtils.getHibernateType(sqlType, columnSize, decimalDigits);
    }

    public static NullableType getHibernateType(int sqlType, int columnSize, int decimalDigits) {
        NullableType rv = Hibernate.SERIALIZABLE;
        if (sqlType == 1 || sqlType == 12) {
            rv = Hibernate.STRING;
        } else if (sqlType == -1) {
            rv = Hibernate.TEXT;
        } else if (sqlType == 2004) {
            rv = Hibernate.BLOB;
        } else if (sqlType == 2005) {
            rv = Hibernate.CLOB;
        } else if (sqlType == 6 || sqlType == 7) {
            rv = Hibernate.FLOAT;
        } else if (sqlType == 4) {
            rv = Hibernate.INTEGER;
        } else if (sqlType == 8) {
            rv = Hibernate.DOUBLE;
        } else if (sqlType == 91) {
            rv = Hibernate.DATE;
        } else if (sqlType == 93) {
            rv = Hibernate.TIMESTAMP;
        } else if (sqlType == 92) {
            rv = Hibernate.TIME;
        } else if (sqlType == 16) {
            rv = Hibernate.BOOLEAN;
        } else if (sqlType == 5) {
            rv = Hibernate.SHORT;
        } else if (sqlType == -7) {
            rv = Hibernate.BOOLEAN;
        } else if (sqlType == -5) {
            rv = Hibernate.LONG;
        } else if (sqlType == 2 || sqlType == 3) {
            rv = decimalDigits == 0 ? (columnSize == 1 ? Hibernate.BYTE : (columnSize < 5 ? Hibernate.SHORT : (columnSize < 10 ? Hibernate.INTEGER : Hibernate.LONG))) : (columnSize < 9 ? Hibernate.FLOAT : Hibernate.DOUBLE);
        }
        return rv;
    }
}

