/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.java;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.ElementSet;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.Parameter;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.ReferenceEntry;
import org.asyrinx.joey.gen.model.java.ReferenceType;
import org.asyrinx.joey.gen.model.java.Type;

public class Reference
extends ElementSet
implements Parameter {
    public static final String HIBERNATE_DIRECTION = "hibernateDirection";
    public static final String DIRECTION_NONE = "none";
    public static final String DIRECTION_FORWARD = "forward";
    public static final String DIRECTION_BACKWARD = "backward";
    public static final String DIRECTION_BIDIRECTIONAL = "bidirectional";
    private Entity referenceClass = null;
    private ReferenceType type = ReferenceType.NORMAL;

    public Reference(Entity parent) {
        super(parent);
    }

    public Reference(Entity parent, String name) {
        super(parent, name);
    }

    public boolean isEntity() {
        return true;
    }

    public Entity getParent() {
        return (Entity)super.getParentElement();
    }

    public void add(ReferenceEntry entry) {
        super.add(entry);
    }

    public boolean contains(ReferenceEntry entry) {
        return super.contains(entry);
    }

    public ReferenceEntry getEntry(int index) {
        return (ReferenceEntry)super.getElement(index);
    }

    public ReferenceEntry getEntry(String name) {
        return (ReferenceEntry)super.getElement(name);
    }

    public ReferenceEntry removeEntry(String name) {
        return (ReferenceEntry)super.removeElement(name);
    }

    public String getReferenceClassName() {
        return this.getReferenceClass() == null ? null : this.getReferenceClass().getName();
    }

    public Entity getReferenceClass() {
        return this.referenceClass;
    }

    public void setReferenceClass(Entity referenceClass) {
        this.referenceClass = referenceClass;
    }

    public boolean containsAsLocal(Property property) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ReferenceEntry entry = (ReferenceEntry)i.next();
            if (entry.getLocal() != property) continue;
            return true;
        }
        return false;
    }

    public boolean containsAsForeign(Property property) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ReferenceEntry entry = (ReferenceEntry)i.next();
            if (entry.getForeign() != property) continue;
            return true;
        }
        return false;
    }

    public String getPropertyNameInReferred(boolean plural) {
        String className = this.getParent().getName();
        String relatedByCol = "";
        List otherRefs = this.getParent().getParent().findReferences(this.getParent(), this.getReferenceClass());
        if (otherRefs.size() > 1) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ReferenceEntry entry = (ReferenceEntry)i.next();
                if (entry.getLocal().getReferencesContainedAsLocal().isEmpty()) continue;
                relatedByCol = String.valueOf(relatedByCol) + entry.getLocal().getCapitalizedName();
            }
        }
        if (StringUtils.isEmpty((String)relatedByCol)) {
            return plural ? StringUtils.uncapitalize((String)(String.valueOf(className) + "s")) : StringUtils.uncapitalize((String)className);
        }
        return plural ? StringUtils.uncapitalize((String)(String.valueOf(className) + "sRelatedBy" + relatedByCol)) : StringUtils.uncapitalize((String)(String.valueOf(className) + "RelatedBy" + relatedByCol));
    }

    public String getPropertyNameInReferred() {
        return this.getPropertyNameInReferred(true);
    }

    public String getPropertyNameInLocal() {
        Entity foreignClass = this.getReferenceClass();
        String className = foreignClass.getName();
        String relCol = "";
        List otherRefs = this.getParent().getReferencesContainedAsForeign(foreignClass);
        if (otherRefs.size() > 1) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ReferenceEntry entry = (ReferenceEntry)i.next();
                if (entry.getLocal().getReferencesContainedAsLocal().isEmpty() && this.getReferenceClass() != this.getParent()) continue;
                relCol = String.valueOf(relCol) + entry.getLocal().getCapitalizedName();
            }
        }
        if (StringUtils.isNotEmpty((String)relCol)) {
            relCol = "RelatedBy" + relCol;
        }
        return StringUtils.uncapitalize((String)(String.valueOf(className) + relCol));
    }

    public ReferenceType getType() {
        return this.type;
    }

    public void setType(ReferenceType type) {
        this.type = type;
    }

    public String getHibernateDirection() {
        return String.valueOf(this.getOption(HIBERNATE_DIRECTION));
    }

    public boolean isHibernateForward() {
        return DIRECTION_FORWARD.equals(this.getHibernateDirection()) || DIRECTION_BIDIRECTIONAL.equals(this.getHibernateDirection());
    }

    public boolean isHibernateBackward() {
        return DIRECTION_BACKWARD.equals(this.getHibernateDirection()) || DIRECTION_BIDIRECTIONAL.equals(this.getHibernateDirection());
    }

    public String getParamName() {
        return this.getPropertyNameInLocal();
    }

    public Type getParamType() {
        return this.getReferenceClass();
    }
}

