/*
 * joey-test and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/27 10:41:55
 */
package org.asyrinx.joey.test.dao;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

/**
 * gUNV
 * 
 * @author takeshi
 */
public abstract class DBTestCaseTx extends DBTestCase {

    /**
     * @param name
     */
    public DBTestCaseTx(String name) {
        super(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.test.dao.DBTestCase#afterSetupContainer()
     */
    protected void afterSetupContainer() throws Throwable {
        super.afterSetupContainer();
        final TransactionManager manager = (TransactionManager) getContainer().getComponent(TransactionManager.class);
        if (manager == null)
            throw new NullPointerException("TransactionManager was not found. check your j2ee.dicon or like that");
        this.setTransactionManager(manager);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.test.dao.DBTestCase#executeRunBare()
     */
    protected void executeRunBare() throws Throwable {
        boolean began = false;
        if (!hasTransaction()) {
            begin();
            began = true;
        }
        try {
            super.executeRunBare();
            if (began) {
                commit();
            }
        } catch (Throwable t) {
            if (began) {
                rollback();
            }
            throw t;
        }
    }

    //

    private TransactionManager transactionManager;

    public final TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public final void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public final boolean hasTransaction() throws SystemException {
        return transactionManager.getStatus() != Status.STATUS_NO_TRANSACTION;
    }

    public final Transaction getTransaction() throws SystemException {
        return transactionManager.getTransaction();
    }

    public final void begin() throws NotSupportedException, SystemException {
        transactionManager.begin();
    }

    public final void commit() throws SecurityException, IllegalStateException, RollbackException,
            HeuristicMixedException, HeuristicRollbackException, SystemException {
        transactionManager.commit();
    }

    public final void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (hasTransaction()) {
            transactionManager.rollback();
        }
    }

    public final Transaction suspend() throws SystemException {
        return transactionManager.suspend();
    }

    public final void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException,
            SystemException {
        transactionManager.resume(transaction);
    }

}