/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 18:00:19
 */
package org.asyrinx.joey.gen.command.rdb;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class CheckIndexEntry extends RdbCommand {

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.IndexEntry)
     */
    public void visit(IndexEntry indexEntry) {
        if (StringUtils.isEmpty(indexEntry.getName()))
            addError(indexEntry, "indexEntry requires name");
        final Index index = indexEntry.getParent();
        final Table table = index.getParent();
        if (table.getColumns().getColumn(indexEntry.getName()) == null)
            addError(indexEntry, "column not found");
    }

}