/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/25 16:10:30
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class SortTablesByExtends extends RdbCommand {

    /**
     *  
     */
    public SortTablesByExtends() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb.RdbCommand#visit(org.asyrinx.joey.gen.model.rdb.Database)
     */
    public void visit(Database database) {
        final int tableCount = database.getTables().size();
        final List list = new ArrayList();
        for (Iterator i = database.getTables().iterator(); i.hasNext();) {
            final Table table = (Table) i.next();
            addTable(table, list);
        }
        if (tableCount != list.size()) {
            addError(database, "failed to sort tables by extends( " + tableCount + " -> " + list.size() + " )");
            return;
        }
        database.getTables().clear();
        for (Iterator i = list.iterator(); i.hasNext();) {
            final Table table = (Table) i.next();
            database.getTables().add(table);
        }
    }

    private void addTable(Table table, List dest) {
        if (table.getExtendsTable() != null) {
            if (!dest.contains(table.getExtendsTable()))
                addTable(table.getExtendsTable(), dest);
        }
        if (!dest.contains(table))
            dest.add(table);
    }

}