/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/14 20:48:18
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.joey.gen.command.java.JavaCommand;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.command.rdb.StandardCommands;
import org.asyrinx.joey.gen.command.rdb2java.NamingStrategy;
import org.asyrinx.joey.gen.command.rdb2java.PackagingStrategy;
import org.asyrinx.joey.gen.command.rdb2java.Rdb2JavaBuilder;
import org.asyrinx.joey.gen.command.rdb2java.TypeMappingStrategy;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.command.Command;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.EntityKeyEntry;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;
import org.asyrinx.joey.gen.model.java.ReferenceEntry;
import org.asyrinx.joey.gen.model.java.ReferenceType;
import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.classes.EmbeddedClassUtils;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorMock;

/**
 * @author akima
 */
public class BasicBuilder implements Rdb2JavaBuilder {

    /**
     *  
     */
    public BasicBuilder() {
        super();
    }

    private final JavaElementBuilder elementBuilder = new JavaElementBuilder();

    private final JavaTypeResolver resolver = new JavaTypeResolver();

    private final JavaReferenceBuilder referenceBuilder = new JavaReferenceBuilder();

    private final JavaPrimaryKeyBuilder pkBuilder = new JavaPrimaryKeyBuilder();

    public AppDomain execute(Databases dbs) {

        final AppDomain result = new AppDomain();
        //
        final Command dbCommand = new StandardCommands();
        dbCommand.execute(dbs);
        //܂NXƂ{vf
        elementBuilder.execute(dbs, result, this.resolver);
        //CaptionProperty
        new CaptionPropertyResolver().execute(dbs, elementBuilder.getRdb2java());
        //pbP[Wݒ
        new PackagePreparer().execute(result, new BasicPackaging(getProperties()));
        //primary keyݒB
        pkBuilder.execute(dbs, elementBuilder.getRdb2java());
        //NXTypeƂĂ̎QƂ
        resolver.execute(result);
        //vpeB̃ftHglݒ
        new DefaultValueBuilder().execute(result);
        //vpeBEnumƂ̊֌Wݒ
        new EnumPropertyBuilder().execute(dbs, elementBuilder.getRdb2java(), this.getNaming());
        //p֌W
        new ExtendsResolver().execute(dbs, elementBuilder.getRdb2java());
        //hNX
        new AssignableEntityResolver().execute(result);
        //NXԂ̊֌WFKɍ\z
        referenceBuilder.execute(dbs, elementBuilder.getRdb2java());
        //importݒ
        new ImportBuilder().execute(result);
        return result;
    }

    /**
     * @return
     */
    public NamingStrategy getNaming() {
        return elementBuilder.getNaming();
    }

    /**
     * @return
     */
    public TypeMappingStrategy getTypeMapping() {
        return elementBuilder.getTypeMapping();
    }

    /**
     * @param naming
     */
    public void setNaming(NamingStrategy naming) {
        elementBuilder.setNaming(naming);
    }

    /**
     * @param typeMapping
     */
    public void setTypeMapping(TypeMappingStrategy typeMapping) {
        elementBuilder.setTypeMapping(typeMapping);
    }

    public Map getRdb2Java() {
        return elementBuilder.getRdb2java();
    }

    /**
     * @return
     */
    public Map getJava2rdb() {
        return elementBuilder.getJava2rdb();
    }

    private Map properties = null;

    public Map getProperties() {
        return properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }
}

class JavaElementBuilder extends RdbVisitorMock {
    private AppDomain appDomain = null;

    private JavaTypeResolver resolver = null;

    final Log log = LogFactory.getLog(this.getClass());

    final Map java2rdb = new HashMap() {
        public Object put(Object key, Object value) {
            if (this.containsKey(key))
                log.warn("java2rdb: key'" + key + "' was overriden.");
            return super.put(key, value);
        }
    };

    private final Map rdb2java = new HashMap() {
        private String toName(Object obj) {
            if (obj instanceof Element)
                return ((Element) obj).getFullName();
            else
                return String.valueOf(obj);
        }

        public Object remove(Object key) {
            final Object value = super.remove(key);
            if (value != null)
                JavaElementBuilder.this.java2rdb.remove(value);
            return value;
        }

        public Object put(Object key, Object value) {
            if (key == null)
                log.warn("rdb2java: key was null. value =" + toName(value));
            if (value == null)
                log.warn("rdb2java: value was null. key =" + toName(key));
            if (this.containsKey(key))
                log.warn("rdb2java: key'" + key + "' was overriden.");
            JavaElementBuilder.this.java2rdb.put(value, key);
            return super.put(key, value);
        }

    };

    private NamingStrategy naming = new BasicNaming();

    private TypeMappingStrategy typeMapping = new BasicTypeMapping();

    public void execute(Databases databases, AppDomain domain, JavaTypeResolver typeResolver) {
        this.appDomain = domain;
        this.resolver = typeResolver;
        final RdbTopDownVisitor topDownVisitor = new RdbTopDownVisitor(this);
        topDownVisitor.visit(databases);
    }

    public void visit(RdbEnumeration enum) {
        final JavaEnumeration result = new JavaEnumeration(this.appDomain, enum.getName(), enum.getValueType());
        result.setOriginal(enum);
        //
        result.setLabel(enum.getLabel());
        //̎_łtemplatẽf[^Ă邩ȂBƂPackagePreparerŒ
        //result.setPackageName(packaging.toPackageName(enum));
        result.setDescription(enum.getDescription());
        result.setValueTypeObj(typeMapping.toJavaType(enum.getValueType()));
        result.getOptions().putAll(enum.getOptions());
        //
        for (Iterator i = enum.iterator(); i.hasNext();) {
            final EnumerationEntry entry = (EnumerationEntry) i.next();
            try {
                result.add((EnumerationEntry) entry.clone());
            } catch (CloneNotSupportedException e) {
                e.printStackTrace();
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
        rdb2java.put(enum, result);
        resolver.addType(result.getFullName(), result);
    }

    public void visit(Table table) {
        final Entity result = new Entity(this.appDomain);
        result.setOriginal(table);
        //
        result.setName(naming.toClassName(table));
        //result.setPackageTemplate(packaging.toPackageName(table));
        result.setDescription(table.getDescription());
        result.setLabel(table.getLabel());
        result.getOptions().putAll(table.getOptions());
        //
        rdb2java.put(table, result);
        resolver.addType(result.getFullName(), result);
    }

    public void visit(Column column) {
        final Entity owner = (Entity) rdb2java.get(column.getParent());
        final Property result = new Property(owner);
        result.setOriginal(column);
        //
        result.setName(naming.toPropertyName(column));
        result.setType(typeMapping.toJavaType(column));
        result.setPrimaryKey(column.isPrimaryKey());
        if (result.getType() == null) {
            JavaEnumeration enumeration = appDomain.getEnumerations().getEnumeration(column.getType());
            if (enumeration != null)
                result.setType(enumeration);
        }
        result.setDefaultValue(column.getDefaultValue());
        result.setDescription(column.getDescription());
        result.setLabel(column.getLabel());
        result.setRequired(column.isRequired());
        result.setMaxLength(column.getSizeAsInt());
        result.setExtended(column.isExtended());
        result.getOptions().putAll(column.getOptions());
        //
        rdb2java.put(column, result);
    }

    /**
     * @return Returns the naming.
     */
    public NamingStrategy getNaming() {
        return naming;
    }

    /**
     * @param naming
     *            The naming to set.
     */
    public void setNaming(NamingStrategy naming) {
        this.naming = naming;
    }

    /**
     * @return Returns the typeMapping.
     */
    public TypeMappingStrategy getTypeMapping() {
        return typeMapping;
    }

    /**
     * @param typeMapping
     *            The typeMapping to set.
     */
    public void setTypeMapping(TypeMappingStrategy typeMapping) {
        this.typeMapping = typeMapping;
    }

    /**
     * @return Returns the rdb2java.
     */
    public Map getRdb2java() {
        return rdb2java;
    }

    /**
     * @return Returns the java2rdb.
     */
    public Map getJava2rdb() {
        return java2rdb;
    }
}

class CaptionPropertyResolver extends RdbCommand {

    private Map rdb2java = null;

    public void execute(Databases databases, Map rdb2javaMap) {
        this.rdb2java = rdb2javaMap;
        new RdbTopDownVisitor(this).visit(databases);
    }

    public void visit(Table table) {
        if (table.getCaptionColumn() == null)
            return;
        final Property property = (Property) rdb2java.get(table.getCaptionColumn());
        if (property == null)
            addError(table.getCaptionColumn(), "property was not found");
        final Entity ownerClass = (Entity) rdb2java.get(table);
        ownerClass.setCaptionProperty(property);
    }

}

class JavaTypeResolver extends JavaCommand {
    private final Map javaName2Type = new HashMap();

    public void addType(String typeName, Type type) {
        this.javaName2Type.put(typeName, type);
    }

    public Type getType(String typeName) {
        final Type result = (Type) this.javaName2Type.get(typeName);
        return (result != null) ? result : EmbeddedClassUtils.get(typeName);
    }

    public void visit(JavaEnumeration enum) {
        if (enum.getValueTypeObj() != null)
            return;
        final Type type = getType(enum.getValueType());
        if (type == null) {
            addError(enum, "type[" + enum.getValueType() + "] is not found.");
            return;
        }
        enum.setValueTypeObj(type);
    }

    public void visit(Property property) {
        if (property.getType() != null)
            return;
        final Type type = getType(property.getTypeName());
        if (type == null) {
            addError(property, "type[" + property.getTypeName() + "] is not found.");
            return;
        }
        property.setType(type);
    }
}

class JavaPrimaryKeyBuilder extends RdbVisitorMock {
    private Map rdb2java = null;

    public void execute(Databases databases, Map rdb2javaMap) {
        this.rdb2java = rdb2javaMap;
        new RdbTopDownVisitor(this).visit(databases);
    }

    public void visit(Table table) {
        final Entity ownerClass = (Entity) rdb2java.get(table);
        if (table.getExtendsTable() != null)
            return;
        final EntityKey pk = new EntityKey(ownerClass, "pk");
        pk.setPrimaryKey(true);
        for (Iterator i = table.getColumns().iterator(); i.hasNext();) {
            final Column column = (Column) i.next();
            if (column.isPrimaryKey()) {
                final Property property = (Property) rdb2java.get(column);
                new EntityKeyEntry(pk, property);
            }
        }
    }
}

class JavaReferenceBuilder extends RdbCommand {
    private Map rdb2java = null;

    public void execute(Databases databases, Map rdb2javaMap) {
        this.rdb2java = rdb2javaMap;
        super.execute(databases);
    }

    public void visit(ForeignKey foreignKey) {
        if (foreignKey.getType() == ForeignKeyType.EXTENDS) {
            rdb2java.remove(foreignKey);
            return;
        }
        final Table localTable = foreignKey.getParent();
        final Table foreignTable = foreignKey.getForeignTable();
        final Entity ownerClass = (Entity) rdb2java.get(localTable);
        final Entity referenceClass = (Entity) rdb2java.get(foreignTable);
        final Reference result = new Reference(ownerClass);
        result.setOriginal(foreignKey);
        result.setType(ReferenceType.get(foreignKey.getType().getName()));
        result.setLabel(foreignKey.getLabel());
        result.setReferenceClass(referenceClass);
        if (result.getOption(Reference.HIBERNATE_DIRECTION) == null) {
            //ftHgo֘A
            result.getOptions().put(Reference.HIBERNATE_DIRECTION, Reference.DIRECTION_BIDIRECTIONAL);
        }
        for (Iterator i = foreignKey.iterator(); i.hasNext();) {
            final ForeignKeyEntry entry = (ForeignKeyEntry) i.next();
            final Property local = (Property) rdb2java.get(entry.getLocalColumn());
            final Property foreign = (Property) rdb2java.get(entry.getForeignColumn());
            if (local == null) {
                addError(foreignKey, "property for column '" + entry.getLocal() + "'" + entry.getLocalColumn()
                        + " not found.");
            }
            if (foreign == null)
                addError(foreignKey, "column '" + entry.getForeign() + "' not found.");
            new ReferenceEntry(result, local, foreign);
        }
        rdb2java.put(foreignKey, result);
    }

}

class DefaultValueBuilder extends JavaCommand {
    public void visit(Property property) {
        if (property.getDefaultValue() != null)
            return;
        if (property.getType() == null) {
            addError(property, "type [" + property.getTypeName() + "] is not found", false);
            return;
        }
        property.setDefaultValue(property.getType().getCategory().getDefaultValue());
    }
}

class EnumPropertyBuilder extends RdbCommand {
    private Map rdb2java = null;

    private NamingStrategy naming = null;

    public void execute(Databases databases, Map rdb2javaMap, NamingStrategy namingStrategy) {
        this.rdb2java = rdb2javaMap;
        this.naming = namingStrategy;
        new RdbTopDownVisitor(this).visit(databases);
    }

    public void visit(Column column) {
        final Property property = (Property) rdb2java.get(column);
        if (StringUtils.isEmpty(column.getEnum()))
            return;
        property.setEnumPropertyName(naming.toEnumPropertyName(property.getName()));
        property.setEnumType(findEnum(column));
    }

    protected JavaEnumeration findEnum(Column column) {
        final RdbEnumeration rdbENum = column.getParent().getParent().getEnumerations()
                .getEnumeration(column.getEnum());
        if (rdbENum == null) {
            addError(column, "enum [" + column.getEnum() + "] is not found.");
            return null;
        }
        final Object javaEnum = rdb2java.get(rdbENum);
        if (javaEnum == null) {
            addError(column, "rdbENum [" + rdbENum.getFullName() + "] has no mapped java class.");
            return null;
        }
        if (javaEnum instanceof JavaEnumeration) {
            return (JavaEnumeration) javaEnum;
        } else {
            addError(column, "enum [" + column.getEnum() + "] is not found.");
            return null;
        }
    }
}

class PackagePreparer extends JavaCommand {

    private PackagingStrategy packaging = null;

    public void execute(AppDomain appDomain, PackagingStrategy packagingStrategy) {
        this.packaging = packagingStrategy;
        execute(appDomain);
    }

    public void visit(Entity entity) {
        packaging.preparePackageNames(entity);
    }

    public void visit(JavaEnumeration enum) {
        packaging.preparePackageName(enum);
    }

}

class ImportBuilder extends JavaCommand {
    public void visit(Entity entity) {
        for (Entity source = entity; source != null; source = source.getSuperClass()) {
            addImportByEntity(entity, source);
        }
    }

    /**
     * @param entity
     */
    private void addImportByEntity(Entity entity, Entity source) {
        if (source.getSuperClass() != null) {
            addImport(entity, source.getSuperClass());
        }
        for (Iterator i = source.getProperties().iterator(); i.hasNext();) {
            final Property property = (Property) i.next();
            addImport(entity, property.getEnumType());
        }
        for (Iterator i = source.getReferences().iterator(); i.hasNext();) {
            final Reference reference = (Reference) i.next();
            addImport(entity, reference.getReferenceClass());
        }
        for (Iterator i = source.getReferreds().iterator(); i.hasNext();) {
            final Reference reference = (Reference) i.next();
            addImport(entity, reference.getParent());
        }
    }

    /**
     * @param entity
     * @param type
     */
    private void addImport(Entity entity, final Type type) {
        if (type == null)
            return;
        if (!type.getPackage().equals(entity.getPackage()))
            entity.getImports().add(type.getFqn());
    }
}

class ExtendsResolver extends RdbCommand {

    private Map rdb2java = null;

    public void execute(Databases databases, Map rdb2javaMap) {
        this.rdb2java = rdb2javaMap;
        new RdbTopDownVisitor(this).visit(databases);
    }

    public void visit(Table table) {
        if (table.getExtendsTable() == null)
            return;
        final Entity subclass = (Entity) rdb2java.get(table);
        final Entity superclass = (Entity) rdb2java.get(table.getExtendsTable());
        subclass.setSuperClass(superclass);
    }
}

class AssignableEntityResolver extends JavaCommand {

    public void visit(Entity javaClass) {
        addToAssignableEntities(javaClass);
    }

    private void addToAssignableEntities(Entity entity) {
        for (Entity current = entity; current != null; current = current.getSuperClass()) {
            current.getAssignableEntities().add(entity);
        }
    }
}