/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/24 17:58:41
 */
package org.asyrinx.joey.gen.hibernate;

import java.sql.Types;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.jdbc.JdbcUtils;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.type.NullableType;

/**
 * @author takeshi
 */
public class HibernateUtils {

    /**
     *  
     */
    public HibernateUtils() {
        super();
    }

    public static NullableType getHibernateType(String sqlTypeName, int columnSize, int decimalDigits) {
        final int sqlType = JdbcUtils.toJdbcType(sqlTypeName);
        return (sqlType == JdbcUtils.UNKNOWN_TYPE) ? null : getHibernateType(sqlType, columnSize, decimalDigits);
    }

    public static NullableType getHibernateType(int sqlType, int columnSize, int decimalDigits) {
        //logger.debug("sqlType=" + sqlType);
        //logger.debug("columnSize=" + columnSize);
        //logger.debug("decimalDigits=" + decimalDigits);
        NullableType rv = Hibernate.SERIALIZABLE;
        if (sqlType == Types.CHAR || sqlType == Types.VARCHAR) {
            rv = Hibernate.STRING;
        } else if (sqlType == Types.LONGVARCHAR) {
            rv = Hibernate.TEXT;
        } else if (sqlType == Types.BLOB) {
            rv = Hibernate.BLOB;
        } else if (sqlType == Types.CLOB) {
            rv = Hibernate.CLOB;
        } else if (sqlType == Types.FLOAT || sqlType == Types.REAL) {
            rv = Hibernate.FLOAT;
        } else if (sqlType == Types.INTEGER) {
            rv = Hibernate.INTEGER;
        } else if (sqlType == Types.DOUBLE) {
            rv = Hibernate.DOUBLE;
        } else if (sqlType == Types.DATE) {
            rv = Hibernate.DATE;
        } else if (sqlType == Types.TIMESTAMP) {
            rv = Hibernate.TIMESTAMP;
        } else if (sqlType == Types.TIME) {
            rv = Hibernate.TIME;
        } else if (sqlType == Types.BOOLEAN) {
            rv = Hibernate.BOOLEAN;
        } else if (sqlType == Types.SMALLINT) {
            rv = Hibernate.SHORT;
        } else if (sqlType == Types.BIT) {
            rv = Hibernate.BOOLEAN;
        } else if (sqlType == Types.BIGINT) {
            rv = Hibernate.LONG;
        } else if (sqlType == Types.NUMERIC || sqlType == Types.DECIMAL) {
            if (decimalDigits == 0) {
                if (columnSize == 1) {
                    rv = Hibernate.BYTE;
                } else if (columnSize < 5) {
                    rv = Hibernate.SHORT;
                } else if (columnSize < 10) {
                    rv = Hibernate.INTEGER;
                } else {
                    rv = Hibernate.LONG;
                }
            } else {
                if (columnSize < 9) {
                    rv = Hibernate.FLOAT;
                } else {
                    rv = Hibernate.DOUBLE;
                }
            }
        }
        return rv;
    }

    public static String toHibernateCascade(String cascade) {
        if (StringUtils.isEmpty(cascade))
            return "none";
        if ("none".equals(cascade))
            return "none";
        if ("all".equals(cascade))
            return "all";
        if ("update".equals(cascade))
            return "save-update";
        if ("delete".equals(cascade))
            return "delete";
        return "none";
    }

}