/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/27 2:01:00
 */
package org.asyrinx.joey.gen.model;


/**
 * @author takeshi
 */
public abstract class AbstractEnumeration extends ElementSet {

    /**
     *  
     */
    public AbstractEnumeration() {
        super((String) null);
    }

    /**
     *  
     */
    public AbstractEnumeration(Element parent, String name) {
        this(parent, name, "int");
    }

    /**
     *  
     */
    public AbstractEnumeration(Element parent, String name, String type) {
        super(parent, name);
        this.valueType = type;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#isEntity()
     */
    public boolean isEntity() {
        return true;
    }

    private String valueType = "int";

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#add(org.asyrinx.joey.gen.model.Element)
     */
    public void add(EnumerationEntry entry) {
        super.add(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#contains(org.asyrinx.joey.gen.model.Element)
     */
    public boolean contains(EnumerationEntry entry) {
        return super.contains(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#getElement(int)
     */
    public EnumerationEntry getEntry(int index) {
        return (EnumerationEntry) super.getElement(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#get(java.lang.String)
     */
    public EnumerationEntry getEntry(String name) {
        return (EnumerationEntry) super.getElement(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#remove(java.lang.String)
     */
    public EnumerationEntry removeEntry(String name) {
        return (EnumerationEntry) super.removeElement(name);
    }
    
    /**
     * @return Returns the valueType.
     */
    public String getValueType() {
        return valueType;
    }

    /**
     * @param valueType
     *               The valueType to set.
     */
    public void setValueType(String type) {
        this.valueType = type;
    }
}