/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 10:04:19
 */
package org.asyrinx.joey.gen.model.java;

import org.apache.commons.lang.enum.Enum;

/**
 * @author takeshi
 */
public class TypeCategory extends Enum {

    /**
     * @param name
     */
    public TypeCategory(String name) {
        super(name);
    }

    public String getDefaultValue() {
        return "null";
    }

    public static final TypeCategory STRING = new TypeCategory("string");

    public static final TypeCategory NUMBER = new TypeCategory("number") {
        public String getDefaultValue() {
            return "0";
        }
    };

    public static final TypeCategory DATE = new TypeCategory("date");

    public static final TypeCategory BOOLEAN = new TypeCategory("boolean") {
        public String getDefaultValue() {
            return "false";
        }
    };

    public static final TypeCategory ENUM = new TypeCategory("enum");

    public static final TypeCategory OTHERS = new TypeCategory("others");

}