package org.asyrinx.joey.gen.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import ognl.OgnlRuntime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.ant.TexenTask;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.seasar.aop.CacheInterceptor;
import org.asyrinx.joey.gen.command.rdb2java.Rdb2JavaBuilder;
import org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder;
import org.asyrinx.joey.gen.hibernate.HibernateUtils;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.xml.DatabasesLoader;
import org.asyrinx.joey.gen.model.rdb.xml.DatabasesLoaderImpl;
import org.asyrinx.joey.gen.model.rdb.xml.XmlToRdbImpl;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.xml.sax.SAXException;

/**
 */
public class DataModelTask extends TexenTask {

    protected List filesets = new ArrayList();

    protected Context context;

    public void addFileset(FileSet set) {
        filesets.add(set);
    }

    private static S2Container container = null;

    public Context initControlContext() throws Exception {
        if (container == null) {
            //System.out.println("################################# init
            // container #################################");
            //ClassLoaderdicont@CDTDǂłȂ̂ŁAdȂŃR|[lg`R[fBO
            //BrownieS2ContainerFactory.create("joey-gen.dicon",
            // this.getProject().getBaseDir().getAbsolutePath());
            container = new S2ContainerImpl();
            container.register(XmlToRdbImpl.class);
            final ComponentDefImpl databasesLoaderDef = new ComponentDefImpl(DatabasesLoaderImpl.class);
            databasesLoaderDef.addAspectDef(new AspectDefImpl(new CacheInterceptor()));
            container.register(databasesLoaderDef);
            final ComponentDefImpl javaBuilderDef = new ComponentDefImpl(BasicBuilder.class);
            javaBuilderDef.addAspectDef(new AspectDefImpl(new CacheInterceptor()));
            container.register(javaBuilderDef);
        }
        return loadModels();
    }

    private Context loadModels() throws IOException, SAXException {
        if (filesets.isEmpty())
            throw new BuildException("You must specify an XML schema or " + "fileset of XML schemas!");
        final Databases databases = loadDatabaseModels();
        //Java֌W̃IuWFNg𐶐
        final Rdb2JavaBuilder builder = (Rdb2JavaBuilder) container.getComponent(Rdb2JavaBuilder.class);
        builder.setProperties(Collections.unmodifiableMap(getProject().getProperties()));
        final AppDomain domain = builder.execute(databases);
        //
        context = new VelocityContext();
        // Place our set of data models into the context along
        // with the names of the databases as a convenience for now.
        context.put("databases", databases);
        context.put("domain", domain);
        context.put("builder", builder);
        context.put("helper", new VelocityHelper(context));
        context.put("stringUtils", new org.asyrinx.brownie.core.lang.StringUtils());
        context.put("hibernateUtils", new HibernateUtils());
        context.put("ognl", new VelocityOgnlHelper(context));
        OgnlRuntime.setPropertyAccessor(Map.class, new VelocityOgnlAccessor(context));
        return context;
    }

    private Databases loadDatabaseModels() throws IOException, SAXException {
        final DatabasesLoader databasesLoader = (DatabasesLoader) container.getComponent(DatabasesLoader.class);
        return databasesLoader.load(this.filesets, this.project);
    }

    private final Log log = LogFactory.getLog(this.getClass());

    public void setContextProperties(String file) {
        super.setContextProperties(file);
        // Map the torque.xxx elements from the env to the contextProperties
        Map env = super.getProject().getProperties();
        for (Iterator i = env.keySet().iterator(); i.hasNext();) {
            String key = (String) i.next();
            if (key.startsWith("joey-gen.")) {
                String newKey = toVelocityKey(key.substring("joey-gen.".length()));
                contextProperties.setProperty(newKey, env.get(key));
                log.debug("joey-gen property available: " + newKey + ":" + env.get(key));
            }
        }
        for (Iterator i = env.keySet().iterator(); i.hasNext();) {
            String key = (String) i.next();
            if (key.startsWith("proj.")) {
                String newKey = toVelocityKey(key);
                contextProperties.setProperty(newKey, env.get(key));
                log.debug("project property available: " + newKey + ":" + env.get(key));
            }
        }
    }

    /**
     * @param newKey
     * @return
     */
    private String toVelocityKey(String newKey) {
        int j = newKey.indexOf(".");
        while (j != -1) {
            newKey = newKey.substring(0, j) + StringUtils.capitalize(newKey.substring(j + 1));
            j = newKey.indexOf(".");
        }
        return newKey;
    }

}