/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/20 13:30:22
 */
package org.asyrinx.joey.gen.task;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author takeshi
 */
public class JoeyGenerateTarget {

    public JoeyGenerateTarget(String targetName, String outputDirectory, String controlTemplate) {
        super();
        this.targetName = targetName;
        this.outputDirectory = outputDirectory;
        this.controlTemplate = controlTemplate;
    }

    private final String targetName;

    private final String outputDirectory;

    private final String controlTemplate;

    public String getControlTemplate() {
        return controlTemplate;
    }

    public String getOutputDirectory() {
        return outputDirectory;
    }

    public String getTargetName() {
        return targetName;
    }

    private static final String OUTPUT_FILE_EXT = ".generation";

    public Object getOutputFile() {
        return this.targetName + OUTPUT_FILE_EXT;
    }

    public String toString() {
        return new ToStringBuilder(this) //
                .append("targetName", getTargetName()) //
                .append("outputDirectory", getOutputDirectory()) //
                .append("controlTemplate", getControlTemplate()) //
                .toString();
    }
}