/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/20 12:59:01
 */
package org.asyrinx.joey.gen.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import ognl.OgnlRuntime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.seasar.aop.CacheInterceptor;
import org.asyrinx.joey.gen.command.rdb2java.Rdb2JavaBuilder;
import org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder;
import org.asyrinx.joey.gen.hibernate.HibernateUtils;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.xml.DatabasesLoader;
import org.asyrinx.joey.gen.model.rdb.xml.DatabasesLoaderImpl;
import org.asyrinx.joey.gen.model.rdb.xml.XmlToRdbImpl;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.xml.sax.SAXException;

/**
 * @author takeshi
 */
public class JoeyGenerateTask extends MultiTargetTexenTask {

    private List loadTargetFile() {
        final List result = new ArrayList();
        try {
            final BufferedReader reader = new BufferedReader(new FileReader(getTargetTextFile()));
            for (String line = reader.readLine(); line != null; line = reader.readLine()) {
                line = line.trim();
                if (StringUtils.isEmpty(line))
                    continue;
                if (line.startsWith("#")) //'#' means comment
                    continue;
                if (result.contains(line))
                    continue;
                log.debug(getTargetTextFile() + " target: " + line);
                result.add(line);
            }
        } catch (IOException e) {
            throw new BuildException(e);
        }
        return result;
    }

    protected List initTargets() {
        final Properties properties = getDefaultProperties();
        final List source = loadTargetFile();
        final List result = new ArrayList();
        for (Iterator i = source.iterator(); i.hasNext();) {
            final String line = (String) i.next();
            final String controlKey = "joey-gen.template.control." + line;
            final String destKey = "joey-gen.template.dest." + line;
            final String controlTemplate = String.valueOf(properties.getProperty(controlKey));
            final String targetStr = String.valueOf(properties.getProperty(destKey));
            final String destDir = getDestDir(targetStr);
            final JoeyGenerateTarget target = new JoeyGenerateTarget(line, destDir, controlTemplate);
            result.add(target);
        }
        return result;
    }

    /**
     * @return
     */
    private Properties getDefaultProperties() {
        final Properties properties = new Properties();
        final InputStream stream = this.getClass().getResourceAsStream("default.properties");
        try {
            properties.load(stream);
        } catch (IOException e) {
            throw new BuildException(e);
        }
        return properties;
    }

    private String getDestDir(String targetStr) {
        if (targetStr == null)
            return getJavaSrcDir();
        if ("javasrc".equals(targetStr))
            return getJavaSrcDir();
        if ("testsrc".equals(targetStr))
            return getTestSrcDir();
        if ("proj".equals(targetStr))
            return getProjDir();
        if ("webapp".equals(targetStr))
            return getWebappDir();
        throw new BuildException("Illegal targetStr '" + targetStr + "'");
    }

    protected List filesets = new ArrayList();

    protected Context context;

    public void addFileset(FileSet set) {
        filesets.add(set);
    }

    private static S2Container container = null;

    public Context initControlContext() {
        if (container == null) {
            //System.out.println("################################# init
            // container #################################");
            //ClassLoaderdicont@CDTDǂłȂ̂ŁAdȂŃR|[lg`R[fBO
            //BrownieS2ContainerFactory.create("joey-gen.dicon",
            // this.getProject().getBaseDir().getAbsolutePath());
            container = new S2ContainerImpl();
            container.register(XmlToRdbImpl.class);
            final ComponentDefImpl databasesLoaderDef = new ComponentDefImpl(DatabasesLoaderImpl.class);
            databasesLoaderDef.addAspectDef(new AspectDefImpl(new CacheInterceptor()));
            container.register(databasesLoaderDef);
            final ComponentDefImpl javaBuilderDef = new ComponentDefImpl(BasicBuilder.class);
            javaBuilderDef.addAspectDef(new AspectDefImpl(new CacheInterceptor()));
            container.register(javaBuilderDef);
        }
        try {
            return loadModels();
        } catch (Exception e) {
            throw new BuildException(e);
        }
    }

    private Context loadModels() throws IOException, SAXException {
        if (filesets.isEmpty())
            throw new BuildException("You must specify an XML schema or " + "fileset of XML schemas!");
        final Databases databases = loadDatabaseModels();
        //Java֌W̃IuWFNg𐶐
        final Rdb2JavaBuilder builder = (Rdb2JavaBuilder) container.getComponent(Rdb2JavaBuilder.class);
        builder.setProperties(Collections.unmodifiableMap(getProject().getProperties()));
        final AppDomain domain = builder.execute(databases);
        //
        context = new VelocityContext();
        context.put("databases", databases);
        context.put("domain", domain);
        context.put("builder", builder);
        context.put("helper", new VelocityHelper(context));
        context.put("stringUtils", new org.asyrinx.brownie.core.lang.StringUtils());
        context.put("hibernateUtils", new HibernateUtils());
        context.put("ognl", new VelocityOgnlHelper(context));
        OgnlRuntime.setPropertyAccessor(Map.class, new VelocityOgnlAccessor(context));
        return context;
    }

    private Databases loadDatabaseModels() throws IOException, SAXException {
        final DatabasesLoader databasesLoader = (DatabasesLoader) container.getComponent(DatabasesLoader.class);
        return databasesLoader.load(this.filesets, this.project);
    }

    private final Log log = LogFactory.getLog(this.getClass());

    public void setContextProperties(String file) {
        super.setContextProperties(file);
        final Map env = super.getProject().getProperties();
        for (Iterator i = env.keySet().iterator(); i.hasNext();) {
            final String key = (String) i.next();
            if (key.startsWith("joey-gen.")) {
                String newKey = toVelocityKey(key.substring("joey-gen.".length()));
                contextProperties.setProperty(newKey, env.get(key));
                log.debug("joey-gen property available: " + newKey + ":" + env.get(key));
            }
        }
        for (Iterator i = env.keySet().iterator(); i.hasNext();) {
            final String key = (String) i.next();
            if (key.startsWith("proj.")) {
                String newKey = toVelocityKey(key);
                contextProperties.setProperty(newKey, env.get(key));
                log.debug("project property available: " + newKey + ":" + env.get(key));
            }
        }
    }

    private String toVelocityKey(String newKey) {
        int j = newKey.indexOf(".");
        while (j != -1) {
            newKey = newKey.substring(0, j) + StringUtils.capitalize(newKey.substring(j + 1));
            j = newKey.indexOf(".");
        }
        return newKey;
    }

    private String targetTextFile = null;

    public String getTargetTextFile() {
        return targetTextFile;
    }

    public void setTargetTextFile(File targetTextFile) {
        try {
            this.targetTextFile = targetTextFile.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    private String projDir = null;

    private String javaSrcDir = null;

    private String testSrcDir = null;

    private String webappDir = null;

    public String getJavaSrcDir() {
        return javaSrcDir;
    }

    public String getProjDir() {
        return projDir;
    }

    public String getTestSrcDir() {
        return testSrcDir;
    }

    public String getWebappDir() {
        return webappDir;
    }

    public void setJavaSrcDir(File javaSrcDir) {
        try {
            this.javaSrcDir = javaSrcDir.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public void setProjDir(File projDir) {
        try {
            this.projDir = projDir.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public void setTestSrcDir(File testSrcDir) {
        try {
            this.testSrcDir = testSrcDir.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public void setWebappDir(File webappDir) {
        try {
            this.webappDir = webappDir.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

}