/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/19 21:13:00
 */
package org.asyrinx.joey.gen.task;

import java.util.Map;

import ognl.ClassResolver;
import ognl.Evaluation;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.TypeConverter;

/**
 * @author takeshi
 */
public class OgnlHelper {

    public OgnlHelper() {
        super();
    }

    public OgnlHelper(Map map) {
        super();
        setContext(map);
    }

    private Map context = null;

    public Map getContext() {
        return context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public void addDefaultContext(Object root, ClassResolver classResolver, Map context) {
        setContext(Ognl.addDefaultContext(root, classResolver, context));
    }

    public void addDefaultContext(Object root, ClassResolver classResolver, TypeConverter converter, Map context) {
        setContext(Ognl.addDefaultContext(root, classResolver, converter, context));
    }

    public void addDefaultContext(Object root, ClassResolver classResolver, TypeConverter converter,
            MemberAccess memberAccess, Map context) {
        setContext(Ognl.addDefaultContext(root, classResolver, converter, memberAccess, context));
    }

    public void addDefaultContext(Object root, Map context) {
        setContext(Ognl.addDefaultContext(root, context));
    }

    public void createDefaultContext(Object root) {
        setContext(Ognl.createDefaultContext(root));
    }

    public void createDefaultContext(Object root, ClassResolver classResolver) {
        setContext(Ognl.createDefaultContext(root, classResolver));
    }

    public void createDefaultContext(Object root, ClassResolver classResolver, TypeConverter converter) {
        setContext(Ognl.createDefaultContext(root, classResolver, converter));
    }

    public void createDefaultContext(Object root, ClassResolver classResolver, TypeConverter converter,
            MemberAccess memberAccess) {
        setContext(Ognl.createDefaultContext(root, classResolver, converter, memberAccess));
    }

    public ClassResolver getClassResolver() {
        return Ognl.getClassResolver(getContext());
    }

    public Evaluation getLastEvaluation() {
        return Ognl.getLastEvaluation(getContext());
    }

    public MemberAccess getMemberAccess() {
        return Ognl.getMemberAccess(getContext());
    }

    public Object getRoot() {
        return Ognl.getRoot(getContext());
    }

    public TypeConverter getTypeConverter() {
        return Ognl.getTypeConverter(getContext());
    }

    public Object getValue(String expression, Object root) throws OgnlException {
        return Ognl.getValue(expression, getContext(), root);
    }

    public Object getValue(String expression, Object root, Class resultType) throws OgnlException {
        return Ognl.getValue(expression, getContext(), root, resultType);
    }

    public Object getValue(String expression) throws OgnlException {
        return Ognl.getValue(expression, getContext());
    }

    public boolean isConstant(String expression) throws OgnlException {
        return Ognl.isConstant(expression);
    }

    public boolean isConstant(String expression, Map context) throws OgnlException {
        return Ognl.isConstant(expression, context);
    }

    public boolean isSimpleNavigationChain(String expression) throws OgnlException {
        return Ognl.isSimpleNavigationChain(expression);
    }

    public boolean isSimpleNavigationChain(String expression, Map context) throws OgnlException {
        return Ognl.isSimpleNavigationChain(expression, context);
    }

    public boolean isSimpleProperty(String expression) throws OgnlException {
        return Ognl.isSimpleProperty(expression);
    }

    public boolean isSimpleProperty(String expression, Map context) throws OgnlException {
        return Ognl.isSimpleProperty(expression, context);
    }

    public Object parseExpression(String expression) throws OgnlException {
        return Ognl.parseExpression(expression);
    }

    public void setClassResolver(Map context, ClassResolver classResolver) {
        Ognl.setClassResolver(context, classResolver);
    }

    public void setMemberAccess(Map context, MemberAccess memberAccess) {
        Ognl.setMemberAccess(context, memberAccess);
    }

    public void setRoot(Map context, Object root) {
        Ognl.setRoot(context, root);
    }

    public void setTypeConverter(Map context, TypeConverter converter) {
        Ognl.setTypeConverter(context, converter);
    }

    public void setValue(String expression, Object root, Object value) throws OgnlException {
        Ognl.setValue(expression, getContext(), root, value);
    }

}