/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/20 8:54:12
 */
package org.asyrinx.joey.gen.task;

import java.util.HashMap;
import java.util.Map;

import ognl.OgnlException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author takeshi
 */
public class VelocityOgnlHelper extends OgnlHelper {

    public VelocityOgnlHelper(Context context) {
        super(toMap(context));
        this.context = context;
    }

    private static Map toMap(Context context) {
        final Map result = new HashMap();
        final Object[] keys = context.getKeys();
        for (int i = 0; i < keys.length; i++)
            result.put(keys[i], context.get(keys[i].toString()));
        return result;
    }

    final Context context;

    static final String VELOCITY_VARIABLE_HEADER = "velocity_";

    final Log log = LogFactory.getLog(this.getClass());

    public Object getValue(String expression) throws OgnlException {
        final Object[] keys = this.context.getKeys();
        for (int i = 0; i < keys.length; i++) {
            final String key = keys[i].toString();
            expression = StringUtils.replace(expression, "$" + key, VELOCITY_VARIABLE_HEADER + key);
            expression = StringUtils.replace(expression, "${" + key + "}", VELOCITY_VARIABLE_HEADER + key);
        }
        if (expression.indexOf("${") > -1) {
            for (int i = 0; i < keys.length; i++) {
                final String key = keys[i].toString();
                log.debug("velocity context: " + key + "=" + this.context.get(key));
            }
        }
        return super.getValue(expression);
    }

}