/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 3:08:59
 */
package test.org.asyrinx.joey.gen.command.rdb;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.command.rdb.CheckIndexEntry;
import org.asyrinx.joey.gen.model.command.ValidationError;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class CheckIndexEntryTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CheckIndexEntryTest.class);
    }

    public void testNormal() {
        final Table table1 = new Table("table1");
        new Column(table1, "col1-1", "int");
        new Column(table1, "col1-2", "int");
        new Column(table1, "col1-3", "int");
        final Index index1_1 = new Index(table1, "named_index_1");
        final IndexEntry entry1_1_1 = new IndexEntry(index1_1, "col1");
        final Index index1_2 = new Index(table1);
        final IndexEntry entry1_2_1 = new IndexEntry(index1_2, "");
        final IndexEntry entry1_2_2 = new IndexEntry(index1_2, "col1-1");
        //
        try {
            new CheckIndexEntry().execute(table1);
            //table1.accept(new RdbVisitorAdapter(new RdbTopDownVisitor(new
            // CheckIndexEntry())));
            fail();
        } catch (ValidationError e) {
            assertEquals(entry1_1_1, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
        entry1_1_1.setName("col1-2");
        try {
            new CheckIndexEntry().execute(table1);
            fail();
        } catch (ValidationError e) {
            assertEquals(entry1_2_1, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
        entry1_2_1.setName("col1-3");
        try {
            new CheckIndexEntry().execute(table1);
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
    }

}