/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/19 21:41:58
 */
package test.org.asyrinx.joey.gen.task;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import ognl.Ognl;
import ognl.OgnlException;

/**
 * @author takeshi
 */
public class OgnlTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(OgnlTest.class);
    }

    public static class A {

        private String propString = null;

        private A ref = null;

        public String getPropString() {
            return propString;
        }

        public void setPropString(String propString) {
            this.propString = propString;
        }

        public A getRef() {
            return ref;
        }

        public void setRef(A ref) {
            this.ref = ref;
        }
    }

    public void testUsge() {
        final A a1 = new A();
        a1.setPropString("propOfA1");
        final A a2 = new A();
        a2.setPropString("propOfA2");
        a2.setRef(a1);
        final A a3 = new A();
        a3.setPropString("propOfA3");
        a3.setRef(a1);
        //
        final Map beans = new HashMap();
        beans.put("a1", a1);
        beans.put("a2", a2);
        //final Map context = Ognl.createDefaultContext(beans);
        final Map context = beans;
        //
        //OgnlRuntime.setPropertyAccessor(A.class, new
        // ObjectPropertyAccessor());
        //
        assertEquals(null, Ognl.getRoot(context));
        try {
            assertEquals(a1, Ognl.getValue("a1", context));
            assertEquals(a2, Ognl.getValue("a2", context));
            assertEquals(a1, Ognl.getValue("a2.ref", context));
            assertEquals(a1, Ognl.getValue("a2.getRef()", context));
            assertEquals("propOfA2", Ognl.getValue("a2.propString", context));
            assertEquals("propOfA1", Ognl.getValue("a2.ref.propString", context));
            Ognl.setValue("a2.propString", context, "propStringAAA");
            assertEquals("propStringAAA", Ognl.getValue("a2.propString", context));
            Ognl.setValue("a2.ref", context, a3);
            assertEquals(a3, Ognl.getValue("a2.ref", context));
            final Object map1 = Ognl.getValue("#{\"1\":\"aaa\",\"2\":\"bbb\"}", null);
            assertEquals(true, map1 instanceof Map);
            assertEquals(2, ((Map) map1).size());
            assertEquals("aaa", ((Map) map1).get("1"));
            assertEquals("bbb", ((Map) map1).get("2"));
            final Object map2 = Ognl.getValue("#{1:\"aaa\",2:\"bbb\"}", null);
            assertEquals(true, map2 instanceof Map);
            assertEquals(2, ((Map) map2).size());
            assertEquals("aaa", ((Map) map2).get(new Integer(1)));
            assertEquals("bbb", ((Map) map2).get(new Integer(2)));
            //
            assertEquals(a3, Ognl.getValue("ref", a2));
            assertEquals("propOfA3", Ognl.getValue("ref.propString", a2));
            //
            assertEquals(a3, Ognl.getValue("ref", a2));
            assertEquals("propOfA3", Ognl.getValue("ref.propString", a2));

        } catch (OgnlException e) {
            e.printStackTrace();
            fail();
        }
    }

}