/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.Table;

public class BasicNaming
extends RdbCommand {
    private String separater = "_";
    private String fkHeader = "f";
    private String indexHeader = "i";

    public String getFkHeader() {
        return this.fkHeader;
    }

    public void setFkHeader(String fkIndexHeader) {
        this.fkHeader = fkIndexHeader;
    }

    public String getIndexHeader() {
        return this.indexHeader;
    }

    public void setIndexHeader(String indexHeader) {
        this.indexHeader = indexHeader;
    }

    public String getSeparater() {
        return this.separater;
    }

    public void setSeparater(String separater) {
        this.separater = separater;
    }

    public void visit(ForeignKey foreignKey) {
        if (foreignKey == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)foreignKey.getName())) {
            return;
        }
        Table table = foreignKey.getParent();
        if (table == null) {
            this.errors.add("foreignKey has no parent table.");
        }
        int index = table.getForeignKeys().indexOf(foreignKey) + 1;
        String name = String.valueOf(this.getFkHeader()) + this.getSeparater() + table.getName() + this.getSeparater() + index;
        foreignKey.setName(name);
    }

    public void visit(Index index) {
        String name;
        ForeignKey foreignKey;
        if (index == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)index.getName())) {
            return;
        }
        Table table = index.getParent();
        if (table == null) {
            this.errors.add("index has no parent table.");
        }
        if ((foreignKey = table.findForeignKey(index)) != null) {
            if (StringUtils.isEmpty((String)foreignKey.getName())) {
                this.visit(foreignKey);
            }
            name = String.valueOf(this.getIndexHeader()) + this.getSeparater() + foreignKey.getName();
        } else {
            int idx = table.getIndexes().indexOf(index) + 1;
            name = String.valueOf(this.getIndexHeader()) + this.getSeparater() + table.getName() + this.getSeparater() + idx;
        }
        index.setName(name);
    }
}

