/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Table;

public class CheckForeignKey
extends RdbCommand {
    public void visit(ForeignKey foreignKey) {
        Table foreignTable;
        if (StringUtils.isEmpty((String)foreignKey.getForeign())) {
            this.addError(foreignKey, "foreignKey requires foreignTable");
        }
        if ((foreignTable = foreignKey.getForeignTable()) == null) {
            this.addError(foreignKey, "table '" + foreignKey.getForeign() + "' not found");
        }
        if (!this.isAvailableCascadeValue(foreignKey.getCascade())) {
            this.addError(foreignKey, "illegal cascade value '" + foreignKey.getCascade() + "'." + "cascade must be " + ArrayUtils.toString((String[])ForeignKey.CASCADES));
        }
    }

    private boolean isAvailableCascadeValue(String cascade) {
        int i = 0;
        while (i < ForeignKey.CASCADES.length) {
            if (ForeignKey.CASCADES[i].equals(cascade)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void visit(ForeignKeyEntry entry) {
        if (StringUtils.isEmpty((String)entry.getLocal())) {
            this.addError(entry, "foreignKeyEntry requires local");
        }
        if (StringUtils.isEmpty((String)entry.getForeign())) {
            this.addError(entry, "foreignKeyEntry requires foreign");
        }
        ForeignKey foreignKey = entry.getParent();
        if (entry.getLocalColumn() == null) {
            this.addError(entry, "column '" + entry.getLocal() + "' not found in table '" + foreignKey.getLocal().getFullName() + "'");
        }
        if (entry.getForeignColumn() == null) {
            this.addError(entry, "column '" + entry.getForeign() + "' not found in table '" + foreignKey.getForeignTable().getFullName() + "'");
        }
    }
}

