/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.command.rdb2java.NamingStrategy;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;

class EnumPropertyBuilder
extends RdbCommand {
    private Map rdb2java = null;
    private NamingStrategy naming = null;

    EnumPropertyBuilder() {
    }

    public void execute(Databases databases, Map rdb2javaMap, NamingStrategy namingStrategy) {
        this.rdb2java = rdb2javaMap;
        this.naming = namingStrategy;
        new RdbTopDownVisitor(this).visit(databases);
    }

    public void visit(Column column) {
        Property property = (Property)this.rdb2java.get(column);
        if (StringUtils.isEmpty((String)column.getEnum())) {
            return;
        }
        property.setEnumPropertyName(this.naming.toEnumPropertyName(property.getName()));
        property.setEnumType(this.findEnum(column));
    }

    protected JavaEnumeration findEnum(Column column) {
        RdbEnumeration rdbENum = column.getParent().getParent().getEnumerations().getEnumeration(column.getEnum());
        if (rdbENum == null) {
            this.addError(column, "enum [" + column.getEnum() + "] is not found.");
            return null;
        }
        Object javaEnum = this.rdb2java.get(rdbENum);
        if (javaEnum == null) {
            this.addError(column, "rdbENum [" + rdbENum.getFullName() + "] has no mapped java class.");
            return null;
        }
        if (javaEnum instanceof JavaEnumeration) {
            return (JavaEnumeration)javaEnum;
        }
        this.addError(column, "enum [" + column.getEnum() + "] is not found.");
        return null;
    }
}

