/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.ColumnSet;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeySet;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexSet;
import org.asyrinx.joey.gen.model.rdb.PrimaryKey;
import org.asyrinx.joey.gen.model.rdb.Unique;

public class Table
extends Element {
    private final ColumnSet columns = new ColumnSet(this);
    private final IndexSet indexes = new IndexSet(this);
    private final IndexSet uniques = new IndexSet(this);
    private final ForeignKeySet foreignKeys = new ForeignKeySet(this);
    private final PrimaryKey primaryKey = new PrimaryKey(this, "pk");
    private String _extends = null;
    private final List referrers = new ArrayList();
    private Column captionColumn = null;

    public Table() {
    }

    public Table(String name) {
        this(null, name, null);
    }

    public Table(String name, String label) {
        this(null, name, label);
    }

    public Table(Database parent, String name) {
        this(parent, name, null);
    }

    public Table(Database parent, String name, String label) {
        super(parent, name, label);
    }

    public Database getParent() {
        return (Database)super.getParentElement();
    }

    public void add(Element element) {
        if (element instanceof Column) {
            this.columns.add((Column)element);
        } else if (element instanceof Unique) {
            this.uniques.add((Unique)element);
        } else if (element instanceof Index) {
            this.indexes.add((Index)element);
        } else if (element instanceof ForeignKey) {
            this.foreignKeys.add((ForeignKey)element);
        } else {
            super.add(element);
        }
    }

    public List getReferrers() {
        return this.referrers;
    }

    public ColumnSet getColumns() {
        return this.columns;
    }

    public ForeignKeySet getForeignKeys() {
        return this.foreignKeys;
    }

    public IndexSet getIndexes() {
        return this.indexes;
    }

    public IndexSet getUniques() {
        return this.uniques;
    }

    public ForeignKey findForeignKey(Index index) {
        Iterator iterator = this.getForeignKeys().iterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            if (foreignKey.getIndex() != index) continue;
            return foreignKey;
        }
        return null;
    }

    public Iterator getPkColumns() {
        ArrayList<Column> result = new ArrayList<Column>();
        Iterator i = this.columns.iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            if (!column.isPrimaryKey()) continue;
            result.add(column);
        }
        return Collections.unmodifiableList(result).iterator();
    }

    public boolean hasPrimaryKey() {
        Iterator i = this.columns.iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            if (!column.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    protected final Table getTable(String name) {
        Database database = this.getParent();
        if (database == null) {
            return null;
        }
        return database.getTables().getTable(name);
    }

    public Table getExtendsTable() {
        return this.getTable(this.getExtends());
    }

    public String getExtends() {
        return this._extends;
    }

    public void setExtends(String extendz) {
        this._extends = extendz;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public Column getCaptionColumn() {
        return this.captionColumn;
    }

    public void setCaptionColumn(Column captionColumn) {
        this.captionColumn = captionColumn;
    }
}

