/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.seasar.aop.CacheInterceptor;
import org.asyrinx.joey.gen.command.rdb2java.Rdb2JavaBuilder;
import org.asyrinx.joey.gen.hibernate.HibernateUtils;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.xml.DatabasesLoader;
import org.asyrinx.joey.gen.task.JoeyGenerateTarget;
import org.asyrinx.joey.gen.task.MultiTargetTexenTask;
import org.asyrinx.joey.gen.task.VelocityHelper;
import org.asyrinx.joey.gen.task.VelocityOgnlAccessor;
import org.asyrinx.joey.gen.task.VelocityOgnlHelper;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.xml.sax.SAXException;

public class JoeyGenerateTask
extends MultiTargetTexenTask {
    protected List filesets = new ArrayList();
    protected Context context;
    private static S2Container container = null;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String targetTextFile = null;
    private String projDir = null;
    private String javaSrcDir = null;
    private String testSrcDir = null;
    private String webappDir = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private List loadTargetFile() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.getTargetTextFile()));
            String line = reader.readLine();
            while (line != null) {
                if (!(StringUtils.isEmpty((String)(line = line.trim())) || line.startsWith("#") || result.contains(line))) {
                    this.log.debug((Object)(String.valueOf(this.getTargetTextFile()) + " target: " + line));
                    result.add(line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        return result;
    }

    protected List initTargets() {
        Properties properties = this.getDefaultProperties();
        List source = this.loadTargetFile();
        ArrayList<JoeyGenerateTarget> result = new ArrayList<JoeyGenerateTarget>();
        Iterator i = source.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            String controlKey = "joey-gen.template.control." + line;
            String destKey = "joey-gen.template.dest." + line;
            String controlTemplate = String.valueOf(properties.getProperty(controlKey));
            String targetStr = String.valueOf(properties.getProperty(destKey));
            String destDir = this.getDestDir(targetStr);
            JoeyGenerateTarget target = new JoeyGenerateTarget(line, destDir, controlTemplate);
            result.add(target);
        }
        return result;
    }

    private Properties getDefaultProperties() {
        Properties properties = new Properties();
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("default.properties");
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        return properties;
    }

    private String getDestDir(String targetStr) {
        if (targetStr == null) {
            return this.getJavaSrcDir();
        }
        if ("javasrc".equals(targetStr)) {
            return this.getJavaSrcDir();
        }
        if ("testsrc".equals(targetStr)) {
            return this.getTestSrcDir();
        }
        if ("proj".equals(targetStr)) {
            return this.getProjDir();
        }
        if ("webapp".equals(targetStr)) {
            return this.getWebappDir();
        }
        throw new BuildException("Illegal targetStr '" + targetStr + "'");
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public Context initControlContext() {
        if (container == null) {
            container = new S2ContainerImpl();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.asyrinx.joey.gen.model.rdb.xml.XmlToRdbImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            container.register((Class)clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.asyrinx.joey.gen.model.rdb.xml.DatabasesLoaderImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentDefImpl databasesLoaderDef = new ComponentDefImpl((Class)clazz2);
            databasesLoaderDef.addAspectDef((AspectDef)new AspectDefImpl((MethodInterceptor)new CacheInterceptor()));
            container.register((ComponentDef)databasesLoaderDef);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentDefImpl javaBuilderDef = new ComponentDefImpl((Class)clazz3);
            javaBuilderDef.addAspectDef((AspectDef)new AspectDefImpl((MethodInterceptor)new CacheInterceptor()));
            container.register((ComponentDef)javaBuilderDef);
        }
        try {
            return this.loadModels();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private Context loadModels() throws IOException, SAXException {
        if (this.filesets.isEmpty()) {
            throw new BuildException("You must specify an XML schema or fileset of XML schemas!");
        }
        Databases databases = this.loadDatabaseModels();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.asyrinx.joey.gen.command.rdb2java.Rdb2JavaBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Rdb2JavaBuilder builder = (Rdb2JavaBuilder)container.getComponent((Object)clazz);
        builder.setProperties(Collections.unmodifiableMap(this.getProject().getProperties()));
        AppDomain domain = builder.execute(databases);
        this.context = new VelocityContext();
        this.context.put("databases", (Object)databases);
        this.context.put("domain", (Object)domain);
        this.context.put("builder", (Object)builder);
        this.context.put("helper", (Object)new VelocityHelper(this.context));
        this.context.put("stringUtils", (Object)new StringUtils());
        this.context.put("hibernateUtils", (Object)new HibernateUtils());
        this.context.put("ognl", (Object)new VelocityOgnlHelper(this.context));
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        OgnlRuntime.setPropertyAccessor(clazz2, (PropertyAccessor)new VelocityOgnlAccessor(this.context));
        return this.context;
    }

    private Databases loadDatabaseModels() throws IOException, SAXException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.asyrinx.joey.gen.model.rdb.xml.DatabasesLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DatabasesLoader databasesLoader = (DatabasesLoader)container.getComponent((Object)clazz);
        return databasesLoader.load(this.filesets, this.project);
    }

    public void setContextProperties(String file) {
        String newKey;
        String key;
        super.setContextProperties(file);
        Hashtable env = super.getProject().getProperties();
        Iterator i = env.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith("joey-gen.")) continue;
            newKey = this.toVelocityKey(key.substring("joey-gen.".length()));
            this.contextProperties.setProperty(newKey, env.get(key));
            this.log.debug((Object)("joey-gen property available: " + newKey + ":" + env.get(key)));
        }
        i = env.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith("proj.")) continue;
            newKey = this.toVelocityKey(key);
            this.contextProperties.setProperty(newKey, env.get(key));
            this.log.debug((Object)("project property available: " + newKey + ":" + env.get(key)));
        }
    }

    private String toVelocityKey(String newKey) {
        int j = newKey.indexOf(".");
        while (j != -1) {
            newKey = String.valueOf(newKey.substring(0, j)) + StringUtils.capitalize((String)newKey.substring(j + 1));
            j = newKey.indexOf(".");
        }
        return newKey;
    }

    public String getTargetTextFile() {
        return this.targetTextFile;
    }

    public void setTargetTextFile(File targetTextFile) {
        try {
            this.targetTextFile = targetTextFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public String getJavaSrcDir() {
        return this.javaSrcDir;
    }

    public String getProjDir() {
        return this.projDir;
    }

    public String getTestSrcDir() {
        return this.testSrcDir;
    }

    public String getWebappDir() {
        return this.webappDir;
    }

    public void setJavaSrcDir(File javaSrcDir) {
        try {
            this.javaSrcDir = javaSrcDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setProjDir(File projDir) {
        try {
            this.projDir = projDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setTestSrcDir(File testSrcDir) {
        try {
            this.testSrcDir = testSrcDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setWebappDir(File webappDir) {
        try {
            this.webappDir = webappDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

