/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.util.Properties;
import javax.transaction.TransactionManager;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.transaction.TransactionManagerLookupFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TransactionManagerLookup;

public class TreeCache
implements Cache {
    private static final String ITEM = "item";
    private static org.jboss.cache.TreeCache cache;
    private final String regionName;
    static /* synthetic */ Class class$net$sf$hibernate$cache$TreeCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeCache(String regionName, Properties props) throws CacheException {
        this.regionName = '/' + regionName.replace('.', '/');
        try {
            Class clazz = class$net$sf$hibernate$cache$TreeCache == null ? (class$net$sf$hibernate$cache$TreeCache = TreeCache.class$("net.sf.hibernate.cache.TreeCache")) : class$net$sf$hibernate$cache$TreeCache;
            synchronized (clazz) {
                if (cache == null) {
                    cache = new org.jboss.cache.TreeCache();
                    PropertyConfigurator config = new PropertyConfigurator();
                    config.configure((Object)cache, "treecache.xml");
                    net.sf.hibernate.transaction.TransactionManagerLookup tml = TransactionManagerLookupFactory.getTransactionManagerLookup(props);
                    if (tml != null) {
                        cache.setTransactionManagerLookup((TransactionManagerLookup)new TransactionManagerLookupAdaptor(tml, props));
                    }
                    cache.start();
                }
            }
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public Object get(Object key) throws CacheException {
        try {
            return cache.get(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            cache.put(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            cache.remove(new Fqn(new Object[]{this.regionName, key}));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            cache.remove(new Fqn((Object)this.regionName));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void destroy() throws CacheException {
        cache.destroy();
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class TransactionManagerLookupAdaptor
    implements TransactionManagerLookup {
        private final net.sf.hibernate.transaction.TransactionManagerLookup tml;
        private final Properties props;

        TransactionManagerLookupAdaptor(net.sf.hibernate.transaction.TransactionManagerLookup tml, Properties props) {
            this.tml = tml;
            this.props = props;
        }

        public TransactionManager getTransactionManager() throws Exception {
            return this.tml.getTransactionManager(this.props);
        }
    }
}

