/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.seasar.container.factory;

import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.seasar.container.factory.BrownieS2ContainerTagHandlerRule;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.container.factory.S2ContainerTagHandlerRule;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.framework.xml.TagHandlerContext;
import org.seasar.framework.xml.TagHandlerRule;

public class BrownieXmlS2ContainerBuilder
implements S2ContainerBuilder {
    private static S2ContainerTagHandlerRule rule_ = new BrownieS2ContainerTagHandlerRule();
    protected final StreamFactory streamFactory;

    public BrownieXmlS2ContainerBuilder() {
        this(StreamFactoryFacade.newFacade());
    }

    public BrownieXmlS2ContainerBuilder(StreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public S2Container build(String path, ClassLoader classLoader) {
        S2Container container = null;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            container = this.build(path);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw throwable;
        }
        {
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            return container;
        }
    }

    public S2Container build(String path) {
        SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
        factory.setValidating(true);
        SAXParser saxParser = SAXParserFactoryUtil.newSAXParser((SAXParserFactory)factory);
        SaxHandler handler = new SaxHandler((TagHandlerRule)rule_);
        handler.registerDtdPath("-//SEASAR//DTD S2Container//EN", "org/seasar/framework/container/factory/components.dtd");
        SaxHandlerParser parser = new SaxHandlerParser(handler, saxParser);
        try {
            return (S2Container)parser.parse(this.streamFactory.newInput(path));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public S2Container include(S2Container parent, String path) {
        SaxHandlerParser parser = this.createSaxHandlerParser(parent, path);
        return (S2Container)parser.parse(path);
    }

    private SaxHandlerParser createSaxHandlerParser(S2Container parent, String path) {
        SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
        factory.setValidating(true);
        SAXParser saxParser = SAXParserFactoryUtil.newSAXParser((SAXParserFactory)factory);
        SaxHandler handler = new SaxHandler((TagHandlerRule)rule_);
        TagHandlerContext ctx = handler.getTagHandlerContext();
        ctx.addParameter("parent", (Object)parent);
        ctx.addParameter("path", (Object)path);
        handler.registerDtdPath("-//SEASAR//DTD S2Container//EN", "org/seasar/framework/container/factory/components.dtd");
        return new SaxHandlerParser(handler, saxParser);
    }
}

