/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.entity.service.impl;

import java.io.Serializable;
import java.util.List;
import net.sf.hibernate.exception.NestableRuntimeException;
import org.apache.commons.beanutils.MethodUtils;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.joey.entity.service.EntityServiceDictionary;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.entity.service.EntityServiceException;

public class EntityServiceDispatcherImpl
implements EntityServiceDispatcher {
    private final EntityServiceDictionary serviceDictionary;

    public EntityServiceDispatcherImpl(EntityServiceDictionary serviceDictionary) {
        this.serviceDictionary = serviceDictionary;
    }

    protected Object getService(Class entityClass) {
        return this.serviceDictionary.getService(entityClass);
    }

    public void delete(Object entity) {
        Object service = this.getService(entity.getClass());
        try {
            MethodUtils.invokeMethod((Object)service, (String)"delete", (Object)entity);
        }
        catch (Exception e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }

    public void save(Object entity) {
        Object service = this.getService(entity.getClass());
        try {
            MethodUtils.invokeMethod((Object)service, (String)"save", (Object)entity);
        }
        catch (Exception e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }

    public Object load(Class entityClass, Serializable key) {
        Object service = this.getService(entityClass);
        try {
            return MethodUtils.invokeMethod((Object)service, (String)"load", (Object)key);
        }
        catch (Exception e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }

    public List select(Class entityClass, IExpression condition) {
        Object service = this.getService(entityClass);
        try {
            Object result = MethodUtils.invokeMethod((Object)service, (String)"select", (Object)condition);
            if (!(result instanceof List)) {
                throw new EntityServiceException("");
            }
            return (List)result;
        }
        catch (Exception e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }
}

