/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.tapestry.components.entity.EntityServiceStrategyImpl;
import org.asyrinx.joey.tapestry.components.entity.IEntityServiceComponent;
import org.asyrinx.joey.tapestry.components.entity.IEntityServiceStrategy;
import org.asyrinx.joey.tapestry.components.entity.table.IListTable;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumn;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableRowRepeatable;
import org.asyrinx.joey.tapestry.components.entity.table.impl.AbstractListTableRow;
import org.asyrinx.joey.tapestry.page.EntityPageDictionary;
import org.asyrinx.joey.tapestry.page.IEntityPagingComponent;
import org.asyrinx.joey.tapestry.page.IEntityPagingStrategy;
import org.asyrinx.joey.tapestry.page.impl.EntityPagingStrategyImpl;

public abstract class ListTableRow
extends AbstractListTableRow
implements IEntityServiceComponent,
IEntityPagingComponent,
IListTableRowRepeatable {
    private Object value = null;
    private Object linkProp = null;
    private final IEntityPagingStrategy pagingStrategy = new EntityPagingStrategyImpl(this);
    protected IEntityServiceStrategy serviceStrategy = new EntityServiceStrategyImpl(this);

    protected void finishLoad() {
        super.finishLoad();
        this.setCellElement("td");
    }

    public void renderCellContent(IMarkupWriter writer, IRequestCycle cycle) {
        IListTableColumn columnDef = this.getColumn();
        Object v = columnDef.getValue(this.getTarget());
        this.setValue(v);
        super.renderCellContent(writer, cycle);
    }

    protected void checkEntity() {
        this.setLinkProp(null);
        if (this.value == null) {
            return;
        }
        IListTable table = this.getTable();
        String pageName = table.getPageDictionary().getPageName(this.value.getClass());
        if (!StringUtils.isEmpty((String)pageName)) {
            this.setLinkProp(this.value);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.checkEntity();
    }

    public Object getLinkProp() {
        return this.linkProp;
    }

    public void setLinkProp(Object linkProp) {
        this.linkProp = linkProp;
    }

    public EntityPageDictionary getPageDictionary() {
        EntityPageDictionary result = this.pagingStrategy.getPageDictionary();
        if (result != null) {
            return result;
        }
        IListTable table = this.getTable();
        if (table == null) {
            return null;
        }
        this.setDetailPageDictionary(table.getPageDictionary());
        return this.getDetailPageDictionary();
    }

    public EntityServiceDispatcher getDispatcher() {
        EntityServiceDispatcher result = this.serviceStrategy.getDispatcher();
        if (result != null) {
            return result;
        }
        IListTable table = this.getTable();
        if (table == null) {
            return null;
        }
        this.setEntityServiceDispatcher(table.getDispatcher());
        return this.getEntityServiceDispatcher();
    }
}

