/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/05 15:56:46
 */
package org.asyrinx.brownie.core.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author takeshi
 */
public class ClassKeyHashMap implements ClassKeyMap {

    /**
     *  
     */
    public ClassKeyHashMap() {
        super();
    }

    /**
     *  
     */
    public ClassKeyHashMap(LookingUp lookingUp) {
        super();
        setLookingUp(lookingUp);
    }

    protected final Map impl = new HashMap();

    public Object get(Class key) {
        return getLookingUp().get(this.impl, key);
    }

    public void put(Class key, Object value) {
        impl.put(key, value);
    }

    public void put(String keyClassName, Object value) throws ClassNotFoundException {
        final Class keyClass = Class.forName(keyClassName);
        this.put(keyClass, value);
    }

    public void clear() {
        impl.clear();
    }

    public boolean containsKey(Class key) {
        return impl.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return impl.containsValue(value);
    }

    public boolean isEmpty() {
        return impl.isEmpty();
    }

    public Set keySet() {
        return impl.keySet();
    }

    public Object remove(Class key) {
        return impl.remove(key);
    }

    public int size() {
        return impl.size();
    }

    public Collection values() {
        return impl.values();
    }

    public interface LookingUp {
        Object get(Map repository, Class key);
    }

    private LookingUp lookingUp = new LookingUpClassFirst();

    public LookingUp getLookingUp() {
        return lookingUp;
    }

    public void setLookingUp(LookingUp lookingUp) {
        this.lookingUp = lookingUp;
    }

    public static class LookingUpClassFirst implements LookingUp {
        private Map repository = null;

        public Object get(Map repository, Class key) {
            this.repository = repository;
            Object result = getBySuperClass(key);
            if (result != null)
                return result;
            result = getByInterfacesOfClass(key);
            if (result != null)
                return result;
            return null;
        }

        private Object getBySuperClass(Class key) {
            for (Class current = key; current != null; current = current.getSuperclass()) {
                final Object result = this.repository.get(current);
                if (result != null)
                    return result;
            }
            return null;
        }

        private Object getByInterfacesOfClass(Class key) {
            for (Class current = key; current != null; current = current.getSuperclass()) {
                final Object result = getByInterfaces(current.getInterfaces());
                if (result != null)
                    return result;
            }
            return null;
        }

        private Object getByInterfaces(Class[] interfaces) {
            for (int i = 0; i < interfaces.length; i++) {
                Object result = this.repository.get(interfaces[i]);
                if (result != null)
                    return result;
                result = this.getByInterfaces(interfaces[i].getInterfaces());
                if (result != null)
                    return result;
            }
            return null;
        }
    }

    public static class LookingUpInterfaceFirst implements LookingUp {
        private Map repository = null;

        public Object get(Map repository, Class key) {
            this.repository = repository;
            return getBySuperClass(key);
        }

        private Object getBySuperClass(Class key) {
            for (Class current = key; current != null; current = current.getSuperclass()) {
                final Object result = getImpl(current);
                if (result != null)
                    return result;
            }
            return null;
        }

        private Object getImpl(Class key) {
            final Object result = this.repository.get(key);
            if (result != null)
                return result;
            return getByInterface(key);
        }

        private Object getByInterface(Class key) {
            final Class[] interfaces = key.getInterfaces();
            for (int i = 0; i < interfaces.length; i++) {
                final Object result = this.getBySuperClass(interfaces[i]);
                if (result != null)
                    return result;
            }
            return null;
        }
    }
}