/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/09 0:01:25
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Map;

/**
 * @author akima
 */
public class ArrayKeyBasedMapTreeAdapter implements MapTree, MapTree.ArrayKey, MapTree.ObjectKey {

    /**
     *  
     */
    public ArrayKeyBasedMapTreeAdapter(MapTree.ArrayKey baseMapTree, MapTreeKeyFactory keyFactory) {
        super();
        this.baseMapTree = baseMapTree;
        this.keyFactory = keyFactory;
    }

    protected final MapTreeKeyFactory keyFactory;

    protected final MapTree.ArrayKey baseMapTree;

    protected MapTreeKey toKey(Object object) {
        return keyFactory.createKey(object);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.ObjectKeyMapTree#getRoot()
     */
    public Map getRoot() {
        return baseMapTree.getRoot();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.ArrayKeyMapTree#get(java.lang.Object[])
     */
    public Object get(Object[] key) {
        return baseMapTree.get(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.MapTree.ArrayKey#getMap(java.lang.Object[])
     */
    public Map getMap(Object[] key) {
        return baseMapTree.getMap(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.ArrayKeyMapTree#put(java.lang.Object[],
     *        java.lang.Object)
     */
    public void put(Object[] key, Object value) {
        baseMapTree.put(key, value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.MapTree#get(org.asyrinx.brownie.core.collection.maptree.MapTreeKey)
     */
    public Object get(MapTreeKey key) {
        return baseMapTree.get(key.toArray());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.MapTree#getMap(org.asyrinx.brownie.core.collection.maptree.MapTreeKey)
     */
    public Map getMap(MapTreeKey key) {
        return baseMapTree.getMap(key.toArray());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.MapTree#put(org.asyrinx.brownie.core.collection.maptree.MapTreeKey,
     *        java.lang.Object)
     */
    public void put(MapTreeKey key, Object value) {
        baseMapTree.put(key.toArray(), value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.ObjectKeyMapTree#get(java.lang.Object)
     */
    public Object get(Object key) {
        return get(toKey(key));
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.MapTree.ObjectKey#getMap(java.lang.Object)
     */
    public Map getMap(Object key) {
        return getMap(toKey(key));
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.ObjectKeyMapTree#put(java.lang.Object,
     *        java.lang.Object)
     */
    public void put(Object key, Object value) {
        put(toKey(key), value);
    }

}