/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/09 0:29:30
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author akima
 */
public interface MapTreeKeyFactory {

    public MapTreeKey createKey(Object object);

    public static class Simple implements MapTreeKeyFactory {
        public MapTreeKey createKey(Object object) {
            if (object == null)
                return MapTreeKey.NULL;
            else if (object instanceof Object[])
                return new MapTreeKey.Default((Object[]) object);
            else if (object instanceof List)
                return new MapTreeKey.Default(((List) object).toArray());
            else
                return null;
        }

    }

    public static class Wrapper implements MapTreeKeyFactory {
        public Wrapper(MapTreeKeyFactory wrapped) {
            this.wrapped = wrapped;
        }

        protected final MapTreeKeyFactory wrapped;

        public MapTreeKey createKey(Object object) {
            return wrapped.createKey(object);
        }

    }

    public static final class BufferedKeyFactory extends Wrapper {
        public BufferedKeyFactory(MapTreeKeyFactory wrapped) {
            super(wrapped);
        }

        public MapTreeKey createKey(Object object) {
            return new MapTreeKey.Buffered(super.createKey(object));
        }
    }

    public static class KeyPool extends Wrapper {
        public KeyPool(MapTreeKeyFactory wrapped) {
            super(wrapped);
        }

        final Map objectKeyMap = new HashMap();

        private MapTreeKey getKey(Object object) {
            return (MapTreeKey) objectKeyMap.get(object);
        }

        public MapTreeKey createKey(Object object) {
            final MapTreeKey pooled = getKey(object);
            if (pooled != null)
                return pooled;
            final MapTreeKey result = super.createKey(object);
            objectKeyMap.put(object, result);
            return result;
        }
    }

}