/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection.matrix;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Akima
 */
public final class MatrixUtils {

	/**
	 * Constructor for MatrixUtils.
	 */
	private MatrixUtils() {
		super();
	}

	static public void convert(MapMatrix source, ListMatrix dest) {
		convert(source, dest, new ArrayList(source.colKeySet()), new ArrayList(
				source.rowKeySet()));
	}

	static public void convert(MapMatrix source, ListMatrix dest,
			List sourceColOrder, List sourceRowOrder) {
		for (int r = 0; r < sourceRowOrder.size(); r++) {
			Object row = sourceRowOrder.get(r);
			for (int c = 0; c < sourceColOrder.size(); c++) {
				Object col = sourceColOrder.get(c);
				dest.put(c, r, source.get(col, row));
			}
		}
	}

}