/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/20 17:15:10
 */
package org.asyrinx.brownie.core.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

/**
 * @author akima
 */
public class SimpleSVBeanLoader implements SVParserListener, SVBeanLoader {

	/**
	 *  
	 */
	public SimpleSVBeanLoader(SVParser parser, SVBeanMapper mapper) {
		super();
		this.parser = parser;
		this.mapper = mapper;
		this.parser.addListener(this);
	}

	private final SVParser parser;

	private final SVBeanMapper mapper;

	public void load(InputStream source) throws IOException {
		final InputStreamReader reader = new InputStreamReader(source);
		parser.parse(reader);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.asyrinx.brownie.core.text.SVParserListener#onLine(java.util.List)
	 */
	public final void onLine(List lines) {
		loadBean(lines);
	}

	protected Object loadBean(List lines) {
		return mapper.loadBean(lines);
	}

}