/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;

/**
 * @author Akima
 */
public abstract class AbstractFileStreamFactory implements StreamFactory {

    /**
     * Constructor for AbstractFileStreamFactory.
     */
    public AbstractFileStreamFactory() {
        super();
    }

    protected String keyToString(Object key) {
        if (key instanceof String)
            return keyStringToString((String) key);
        else if (key instanceof File) {
            final String filePath = keyFileToString((File) key);
            return keyStringToString(filePath);
        }
        return String.valueOf(key);
    }

    protected String keyFileToString(File key) {
        return key.getAbsolutePath();
    }

    protected String keyStringToString(String key) {
        return key;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#getPath4Log(java.lang.Object)
     */
    public String getPath4Log(Object key) {
        return keyToString(key);
    }

}