/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author Akima
 */
public class ClassResourceStreamFactory extends AbstractFileStreamFactory {

    /**
     * Constructor for ClassResourceStreamFactory.
     */
    public ClassResourceStreamFactory() {
        this(null);
    }

    /**
     * Constructor for ClassResourceStreamFactory.
     */
    public ClassResourceStreamFactory(ClassLoader classLoader) {
        super();
        if (classLoader == null)
            classLoader = Thread.currentThread().getContextClassLoader();
        this.classLoader = classLoader;
    }

    private final ClassLoader classLoader;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#newInput(java.lang.Object)
     */
    public InputStream newInput(Object key) throws IOException {
        return createNewInput(key);
    }

    /**
     * hNX炱̃NXƓ悤ɌĂяoĂ郁\bhłB
     * inline΂悢悤Ɍ܂AhNX̂قł́AInvocationInfo
     * gČĂяõ\bh̃NXdvɂȂ܂̂ŁAςȂłB
     * 
     * @param key
     * @return
     * @throws FileNotFoundException
     */
    protected final InputStream createNewInput(Object key) throws FileNotFoundException {
        final String resourceName = keyToString(key);
        final InputStream result = this.getClassLoader().getResourceAsStream(resourceName);
        if (result == null)
            throw new FileNotFoundException(resourceName);
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory#keyFileToString(java.io.File)
     */
    protected String keyFileToString(File key) {
        return key.getPath();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#newOutput(java.lang.Object)
     */
    public OutputStream newOutput(Object key) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#getPath4Log(java.lang.Object)
     */
    public String getPath4Log(Object key) {
        return keyToString(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#getCaption()
     */
    public String getCaption() {
        return "class resource";
    }

    protected ClassLoader getClassLoader() {
        return classLoader;
    }
}