/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/15
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.core.log.DispatchLog;

/**
 * @author akima
 */
public class StreamFactoryFacade implements StreamFactory {

    /**
     *  
     */
    public StreamFactoryFacade() {
        super();
    }

    /**
     * @see java.lang.Object#clone()
     * @return
     */
    public StreamFactoryFacade copy() {
        final StreamFactoryFacade result = new StreamFactoryFacade();
        result.factories.addAll(this.factories);
        return result;
    }

    private final List factories = new ArrayList();

    final DispatchLog log = new DispatchLog(LogFactory.getLog(this.getClass()));

    /**
     * @see org.asyrinx.io.sf.StreamFactory#newInput(java.lang.Object)
     */
    public InputStream newInput(Object key) throws IOException {
        final Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            final StreamFactory factory = (StreamFactory) iterator.next();
            try {
                final InputStream result = factory.newInput(key);
                if (result != null) {
                    final String logPath = factory.getPath4Log(key);
                    this.log.log("load: " + logPath + "@" + factory.getCaption());
                    return result;
                }
            } catch (IOException e) {
                //ignore exception
            }
        }
        throw new IOException("no StreamFactory for key '" + key + "'. on " + this.getPath4Log(key));
    }

    /**
     * @see org.asyrinx.io.sf.StreamFactory#newOutput(java.lang.Object)
     */
    public OutputStream newOutput(Object key) throws IOException {
        final Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            final StreamFactory factory = (StreamFactory) iterator.next();
            try {
                final OutputStream result = factory.newOutput(key);
                if (result != null)
                    return result;
            } catch (IOException e) {
                //ignore exception
            }
        }
        throw new IOException("no StreamFactory for \"" + key + "\"");
    }

    public static StreamFactoryFacade newFacade() {
        return newFacade(IteratorUtils.EMPTY_ITERATOR);
    }

    public static StreamFactoryFacade newFacade(String filenames) {
        return newFacade(FileNameUtils.parseFileNames(filenames));
    }

    public static StreamFactoryFacade newFacade(Collection filenames) {
        return newFacade(filenames.iterator());
    }

    public static StreamFactoryFacade newFacade(Iterator filenameIterator) {
        final StreamFactoryFacade result = new StreamFactoryFacade();
        result.add(new ClassResourceStreamFactory());
        result.add(new SimpleFileStreamFactory());
        while (filenameIterator.hasNext()) {
            final File path = FileNameUtils.toFile(filenameIterator.next());
            if (path.isDirectory()) {
                result.add(new DirectoryBaseFileStreamFactory(path.getAbsolutePath()));
            } else if (FileNameUtils.hasZipExtension(path.getPath())) {
                result.add(new ZipEntryFileStreamFactory(path.getPath()));
            } else {
                final Log log = LogFactory.getLog(StreamFactoryFacade.class);
                log.warn("path\"" + path.getPath() + "\" was not found. @ " + result.getCaption());
            }
        }
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#getPath4Log(java.lang.Object)
     */
    public String getPath4Log(Object key) {
        final StringBuffer result = new StringBuffer();
        result.append("[");
        for (Iterator i = this.factories.iterator(); i.hasNext();) {
            final StreamFactory factory = (StreamFactory) i.next();
            result.append(factory.getPath4Log(key));
            if (i.hasNext())
                result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#getCaption()
     */
    public String getCaption() {
        final StringBuffer result = new StringBuffer();
        result.append("[");
        for (Iterator i = this.factories.iterator(); i.hasNext();) {
            final StreamFactory factory = (StreamFactory) i.next();
            result.append(factory.getCaption());
            if (i.hasNext())
                result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public StreamFactoryFacade addRelativeClassResourceSF() {
        this.add(new RelativeClassResourceStreamFactory(StreamFactoryFacade.class.getName()));
        return this;
    }

    /**
     * @param index
     * @param element
     */
    public void add(int index, StreamFactory element) {
        factories.add(index, element);
    }

    /**
     * @param o
     * @return
     */
    public boolean add(StreamFactory o) {
        return factories.add(o);
    }

    /**
     *  
     */
    public void clear() {
        factories.clear();
    }

    /**
     * @param o
     * @return
     */
    public boolean contains(StreamFactory o) {
        return factories.contains(o);
    }

    /**
     * @param index
     * @return
     */
    public StreamFactory get(int index) {
        return (StreamFactory) factories.get(index);
    }

    /**
     * @param o
     * @return
     */
    public int indexOf(StreamFactory o) {
        return factories.indexOf(o);
    }

    /**
     * @return
     */
    public boolean isEmpty() {
        return factories.isEmpty();
    }

    /**
     * @return
     */
    public Iterator iterator() {
        return factories.iterator();
    }

    /**
     * @param index
     * @return
     */
    public StreamFactory remove(int index) {
        return (StreamFactory) factories.remove(index);
    }

    /**
     * @param o
     * @return
     */
    public boolean remove(StreamFactory o) {
        return factories.remove(o);
    }

    /**
     * @return
     */
    public int size() {
        return factories.size();
    }

    public String getDefaultLevel() {
        return log.getDefaultLevel();
    }

    public void setDefaultLevel(String string) {
        log.setDefaultLevel(string);
    }
}