/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/24 5:41:13
 */
package org.asyrinx.brownie.core.query;

import org.apache.commons.lang.enum.Enum;
import org.asyrinx.brownie.core.query.model.Field;
import org.asyrinx.brownie.core.query.model.Table;

/**
 * @author takeshi
 */
public abstract class StatementType extends Enum {

    /**
     *  
     */
    public StatementType(String name) {
        super(name);
    }

    abstract public String getFieldName(Field field);

    abstract public String getTableName(Table table);

    public static final StatementType SQL = new StatementType("sql") {
        public String getFieldName(Field field) {
            return field.getRdbName();
        }

        public String getTableName(Table table) {
            return table.getRdbName();
        }
    };

    public static final StatementType HQL = new StatementType("hql") {
        public String getFieldName(Field field) {
            return field.getJavaName();
        }

        public String getTableName(Table table) {
            return table.getJavaName();
        }
    };

}