/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/10 2:17:15
 */
package org.asyrinx.brownie.core.query.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author takeshi
 */
public class ForeignKey {

    /**
     *  
     */
    public ForeignKey(Table local, Table foreign, String localPropertyName) {
        super();
        this.local = local;
        this.foreign = foreign;
        this.localPropertyName = localPropertyName;
    }

    private final Table local;

    private final Table foreign;

    private final String localPropertyName;

    public Table getForeign() {
        return foreign;
    }

    public Table getLocal() {
        return local;
    }

    public String getLocalPropertyName() {
        return localPropertyName;
    }

    private final List entries = new ArrayList();

    public boolean add(ForeignKeyEntry o) {
        return entries.add(o);
    }

    public void clear() {
        entries.clear();
    }

    public boolean contains(ForeignKeyEntry entry) {
        return entries.contains(entry);
    }

    public ForeignKeyEntry get(int index) {
        return (ForeignKeyEntry) entries.get(index);
    }

    public int indexOf(ForeignKeyEntry entry) {
        return entries.indexOf(entry);
    }

    public boolean isEmpty() {
        return entries.isEmpty();
    }

    public Iterator iterator() {
        return entries.iterator();
    }

    public boolean remove(ForeignKeyEntry entry) {
        return entries.remove(entry);
    }

    public int size() {
        return entries.size();
    }

    public ForeignKeyEntry[] toArray() {
        return (ForeignKeyEntry[]) entries.toArray();
    }
}