/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.sql2;

/**
 * @author akima
 */
public class Select {

	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	/**
	 * @see org.asyrinx.brownie.core.sql2.SqlBuilder#toSql(org.asyrinx.brownie.core.sql2.Select)
	 */
	public String toSql() {
		final SqlBuilder builder = new BasicSqlBuilder();
		return builder.toSql(this);
	}

	private final Fields selectFields = new Fields();

	private final Tables fromTables = new Tables();

	private final Conditions whereConditions = new Conditions();

	private final Fields groupByFields = new Fields();

	private final Conditions havingConditions = new Conditions();

	private final Fields orderByFields = new Fields();

	private boolean distinct = false;

	public boolean isDistinct() {
		return distinct;
	}

	public void setDistinct(boolean b) {
		this.distinct = b;
	}

	/**
	 * @return
	 */
	public Tables getFromTables() {
		return fromTables;
	}

	/**
	 * @return
	 */
	public Fields getGroupByFields() {
		return groupByFields;
	}

	/**
	 * @return
	 */
	public Conditions getHavingConditions() {
		return havingConditions;
	}

	/**
	 * @return
	 */
	public Fields getOrderByFields() {
		return orderByFields;
	}

	/**
	 * @return
	 */
	public Fields getSelectFields() {
		return selectFields;
	}

	/**
	 * @return
	 */
	public Conditions getWhereConditions() {
		return whereConditions;
	}

}