/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/03 0:06:32
 */
package org.asyrinx.brownie.core.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

/**
 * @author takeshi
 */
public class NullableFormat extends Format {

    /**
     *  
     */
    public NullableFormat(Format wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final Format wrapped;

    private String formatResultWhenNull = "";

    private Object parseResultWhenNull = null;

    /*
     * (non-Javadoc)
     * 
     * @see java.text.Format#parseObject(java.lang.String,
     *      java.text.ParsePosition)
     */
    public Object parseObject(String source, ParsePosition pos) {
        if (source == null) {
            return this.getParseResultWhenNull();
        } else {
            return this.wrapped.parseObject(source, pos);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.text.Format#parseObject(java.lang.String)
     */
    public Object parseObject(String source) throws ParseException {
        if (source == null) {
            return this.getParseResultWhenNull();
        } else {
            return this.wrapped.parseObject(source);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.text.Format#format(java.lang.Object, java.lang.StringBuffer,
     *      java.text.FieldPosition)
     */
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return new StringBuffer(this.getFormatResultWhenNull());
        } else {
            return this.wrapped.format(obj, toAppendTo, pos);
        }
    }

    public String getFormatResultWhenNull() {
        return formatResultWhenNull;
    }

    public void setFormatResultWhenNull(String formatResultWhenNull) {
        this.formatResultWhenNull = formatResultWhenNull;
    }

    public Object getParseResultWhenNull() {
        return parseResultWhenNull;
    }

    public void setParseResultWhenNull(Object parseResultWhenNull) {
        this.parseResultWhenNull = parseResultWhenNull;
    }
}