/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 4:13:17
 */
package org.asyrinx.brownie.core.util;

import java.util.Comparator;

import org.asyrinx.brownie.core.lang.NumberUtils;

/**
 * @author akima
 */
public class NumberComparator implements Comparator {

    /**
     *  
     */
    public NumberComparator() {
        super();
    }

    private SortType sortType = NUM_NULL_STR;

    /*
     * (non-Javadoc)
     * 
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    public int compare(Object o1, Object o2) {
        return sortType.compare(o1, o2, numSortValue, strSortValue);
    }

    private int numSortValue = 1;

    private int strSortValue = 1;

    private static int inverseToInt(boolean b) {
        return b ? -1 : 1;
    }

    private static boolean isInversed(int value) {
        return value == -1;
    }

    /**
     * @return Returns the numSortValue.
     */
    public boolean isInverseNumber() {
        return isInversed(numSortValue);
    }

    /**
     * @param numSortValue
     *               The numSortValue to set.
     */
    public void setInverseNumber(boolean inverseNumber) {
        this.numSortValue = inverseToInt(inverseNumber);
    }

    /**
     * @return Returns the strSortValue.
     */
    public boolean isInverseString() {
        return isInversed(strSortValue);
    }

    /**
     * @param strSortValue
     *               The strSortValue to set.
     */
    public void setInverseString(boolean inverseString) {
        this.strSortValue = inverseToInt(inverseString);
    }

    /**
     * @return Returns the sortType.
     */
    public SortType getSortType() {
        return sortType;
    }

    /**
     * @param sortType
     *               The sortType to set.
     */
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    public static final SortType NULL_NUM_STR = new SortType(1, 2, 3);

    public static final SortType NULL_STR_NUM = new SortType(1, 3, 2);

    public static final SortType NUM_NULL_STR = new SortType(2, 1, 3);

    public static final SortType NUM_STR_NULL = new SortType(3, 1, 2);

    public static final SortType STR_NUM_NULL = new SortType(3, 2, 1);

    public static final SortType STR_NULL_NUM = new SortType(2, 3, 1);

}

final class SortType {
    SortType(int nullIndex, int numIndex, int strIndex) {
        this.nullIndex = nullIndex;
        this.numIndex = numIndex;
        this.strIndex = strIndex;
    }

    private final int nullIndex;

    private final int numIndex;

    private final int strIndex;

    public int compare(Object o1, Object o2, int numSortValue, int strSortValue) {
        final Number n1 = NumberUtils.isNumber(o1) ? NumberUtils.toNumber(o1) : null;
        final Number n2 = NumberUtils.isNumber(o2) ? NumberUtils.toNumber(o2) : null;
        if ((o1 == null) && (o2 == null))
            return 0;
        if (o1 == null)
            return compareToNull(n2);
        if (o2 == null)
            return -compareToNull(n1);
        if ((n1 != null) && (n2 != null))
            return (n1.doubleValue() == n2.doubleValue()) ? 0 : (n1.doubleValue() > n2.doubleValue()) ? numSortValue
                    : -numSortValue;
        else if (n1 != null)
            return compareNumAndStr();
        else if (n2 != null)
            return -compareNumAndStr();
        return o1.toString().compareTo(o2.toString()) * strSortValue;
    }

    private int compareToNull(Number num) {
        switch (nullIndex) {
        case 1:
            return -1;
        case 2:
            if (num == null)
                return (nullIndex < strIndex) ? -1 : 1;
            else
                return (nullIndex < numIndex) ? -1 : 1;
        case 3:
            return 1;
        }
        return 0;
    }

    private int compareNumAndStr() {
        return (numIndex < strIndex) ? -1 : 1;
    }

}