/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

import java.util.Date;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

/**
 * @author akima
 */
public class SimpleDateRange {

	/**
	 *  
	 */
	public SimpleDateRange(SimpleDate from, SimpleDate to) {
		super();
		this.from = from;
		this.to = to;
	}

	/**
	 *  
	 */
	public SimpleDateRange(DateRange dateRange) {
		this(toSimpleDate(dateRange.getFrom()), toSimpleDate(dateRange.getTo()));
	}

	/**
	 *  
	 */
	public SimpleDateRange(int fromYear, int fromMonth, int fromDay,
			int toYear, int toMonth, int toDay) {
		this(toSimpleDate(fromYear, fromMonth, fromDay), toSimpleDate(toYear,
				toMonth, toDay));
	}

	private static SimpleDate toSimpleDate(int y, int m, int d) {
		if (d < 1)
			return null;
		else
			return new SimpleDate(y, m, d);
	}

	public static SimpleDate toSimpleDate(Date d) {
		if (d != null)
			return new SimpleDate(d);
		else
			return null;
	}

	private final SimpleDate from;

	private final SimpleDate to;

	/**
	 * @param obj
	 * @return @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof SimpleDateRange) {
			final SimpleDateRange range = (SimpleDateRange) obj;
			return ObjectUtils.equals(this.from, range.from)
					&& ObjectUtils.equals(this.to, range.to);
		} else {
			return super.equals(obj);
		}
	}

	public boolean include(SimpleDate when) {
		if (from == null && to == null) {
			return true;
		} else if (from != null && to == null) {
			return from.before(when) || from.equals(when);
		} else if (from == null && to != null) {
			return to.after(when) || to.equals(when);
		} else {
			return (from.before(when) || from.equals(when))
					&& (to.after(when) || to.equals(when));
		}
	}

	/**
	 * @return @see java.lang.Object#toString()
	 */
	public String toString() {
		return StringUtils.defaultString(from.toString()) + "-"
				+ StringUtils.defaultString(to.toString());
	}

	/**
	 * @return
	 */
	public SimpleDate getFrom() {
		return from;
	}

	/**
	 * @return
	 */
	public SimpleDate getTo() {
		return to;
	}

	/**
	 * @return
	 */
	public int getFromDay() {
		return (from == null) ? 0 : from.getDay();
	}

	/**
	 * @return
	 */
	public int getFromMonth() {
		return (from == null) ? 0 : from.getMonth();
	}

	/**
	 * @return
	 */
	public int getFromYear() {
		return (from == null) ? 0 : from.getYear();
	}

	/**
	 * @return
	 */
	public int getToDay() {
		return (to == null) ? 0 : to.getDay();
	}

	/**
	 * @return
	 */
	public int getToMonth() {
		return (to == null) ? 0 : to.getMonth();
	}

	/**
	 * @return
	 */
	public int getToYear() {
		return (to == null) ? 0 : to.getYear();
	}

}