/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/26 2:22:51
 */
package org.asyrinx.brownie.core.xml.dom;

import java.util.HashSet;
import java.util.Set;

/**
 * @author takeshi
 */
public interface RenderingDuplicated {

    void clear();

    boolean addBean(Object bean);

    boolean isDuplicated(Object bean);

    public static final RenderingDuplicated NULL = new RenderingDuplicated() {
        public void clear() {
        }

        public boolean addBean(Object bean) {
            return true;
        }

        public boolean isDuplicated(Object bean) {
            return false;
        }
    };

    public static final RenderingDuplicated TAKE_FIRST = new RenderingDuplicated() {
        private final Set beans = new HashSet();

        public void clear() {
            this.beans.clear();
        }

        public boolean addBean(Object bean) {
            return this.beans.add(bean);
        }

        public boolean isDuplicated(Object bean) {
            return this.beans.contains(bean);
        }
    };
}