/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.wrapper;

import java.util.List;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.FetchMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Order;
import net.sf.hibernate.transform.ResultTransformer;

/**
 * @author akima
 */
public class CriteriaWrapper implements Criteria {

	/**
	 *  
	 */
	public CriteriaWrapper(Criteria wrapped) {
		super();
		this.wrapped = wrapped;
	}

	protected final Criteria wrapped;

	/**
	 * @param criterion
	 * @return
	 */
	public Criteria add(Criterion criterion) {
		return wrapped.add(criterion);
	}

	/**
	 * @param order
	 * @return
	 */
	public Criteria addOrder(Order order) {
		return wrapped.addOrder(order);
	}

	/**
	 * @param associationPath
	 * @param alias
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Criteria createAlias(String associationPath, String alias)
			throws HibernateException {
		return wrapped.createAlias(associationPath, alias);
	}

	/**
	 * @param associationPath
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Criteria createCriteria(String associationPath)
			throws HibernateException {
		return wrapped.createCriteria(associationPath);
	}

	/**
	 * @param associationPath
	 * @param alias
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Criteria createCriteria(String associationPath, String alias)
			throws HibernateException {
		return wrapped.createCriteria(associationPath, alias);
	}

	/**
	 * @return
	 */
	public Class getCriteriaClass() {
		return wrapped.getCriteriaClass();
	}

	/**
	 * @param alias
	 * @return
	 */
	public Class getCriteriaClass(String alias) {
		return wrapped.getCriteriaClass(alias);
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public List list() throws HibernateException {
		return wrapped.list();
	}

	/**
	 * @return 
	 * @deprecated
	 */
	public Criteria returnMaps() {
		return wrapped.returnMaps();
	}

	/**
	 * @return 
	 * @deprecated
	 */
	public Criteria returnRootEntities() {
		return wrapped.returnRootEntities();
	}

	/**
	 * @param associationPath
	 * @param mode
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Criteria setFetchMode(String associationPath, FetchMode mode)
			throws HibernateException {
		return wrapped.setFetchMode(associationPath, mode);
	}

	/**
	 * @param firstResult
	 * @return
	 */
	public Criteria setFirstResult(int firstResult) {
		return wrapped.setFirstResult(firstResult);
	}

	/**
	 * @param alias
	 * @param lockMode
	 * @return
	 */
	public Criteria setLockMode(String alias, LockMode lockMode) {
		return wrapped.setLockMode(alias, lockMode);
	}

	/**
	 * @param lockMode
	 * @return
	 */
	public Criteria setLockMode(LockMode lockMode) {
		return wrapped.setLockMode(lockMode);
	}

	/**
	 * @param maxResults
	 * @return
	 */
	public Criteria setMaxResults(int maxResults) {
		return wrapped.setMaxResults(maxResults);
	}

	/**
	 * @param timeout
	 * @return
	 */
	public Criteria setTimeout(int timeout) {
		return wrapped.setTimeout(timeout);
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Object uniqueResult() throws HibernateException {
		return wrapped.uniqueResult();
	}

	/**
	 * @param arg0
	 * @return
	 */
	public Criteria setCacheable(boolean arg0) {
		return wrapped.setCacheable(arg0);
	}

	/**
	 * @param arg0
	 * @return
	 */
	public Criteria setCacheRegion(String arg0) {
		return wrapped.setCacheRegion(arg0);
	}

	/**
	 * @param arg0
	 * @return
	 */
	public Criteria setFetchSize(int arg0) {
		return wrapped.setFetchSize(arg0);
	}

	/**
	 * @param arg0
	 * @return
	 */
	public Criteria setResultTransformer(ResultTransformer arg0) {
		return wrapped.setResultTransformer(arg0);
	}

}