/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.wrapper;

import java.util.Collection;

import javax.xml.transform.TransformerException;

import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;

import org.w3c.dom.Document;

/**
 * @author akima
 */
public class DatabinderWrapper implements Databinder {

	/**
	 *  
	 */
	public DatabinderWrapper(Databinder wrapped) {
		super();
		this.wrapped = wrapped;
	}

	protected final Databinder wrapped;

	/**
	 * @param object
	 * @return
	 */
	public Databinder bind(Object object) {
		return wrapped.bind(object);
	}

	/**
	 * @param objects
	 * @return
	 */
	public Databinder bindAll(Collection objects) {
		return wrapped.bindAll(objects);
	}

	/**
	 * @param initializeLazy
	 */
	public void setInitializeLazy(boolean initializeLazy) {
		wrapped.setInitializeLazy(initializeLazy);
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 * @throws javax.xml.transform.TransformerException
	 */
	public Document toDOM() throws HibernateException, TransformerException {
		return wrapped.toDOM();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Document toGenericDOM() throws HibernateException {
		return wrapped.toGenericDOM();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public String toGenericXML() throws HibernateException {
		return wrapped.toGenericXML();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 * @throws javax.xml.transform.TransformerException
	 */
	public String toXML() throws HibernateException, TransformerException {
		return wrapped.toXML();
	}

}